#!/bin/sh
#
# Commits, tags the commit with the current version number, and pushes
# both the commit and the tag. Used by setup_release_factory to push
# to the release repo.

cd ../twitchsdk/include

# store the version number into a temp file in a form like: "v1.3"
# (where 1 is the major version number, 3 is the minor)
if [ -f "../versionlog.txt" ]; then
	rm ../versionlog.txt
fi

env echo -n "v" >> ../versionlog.txt
grep 'kMajorVersion' version.h | awk ' {printf substr($5,0,length($5)-1)}' >> ../versionlog.txt
env echo -n '.' >> ../versionlog.txt
grep 'kMinorVersion'  version.h | awk ' {printf substr($5,0,length($5)-1)}' >> ../versionlog.txt

# generate the commit message: version number followed by new changes found in CHANGES.md
cd ..
git diff --cached CHANGES.md | egrep '^\+[^\+]' | sed -e 's/^+//' > description.txt
env echo -n 'SDK Release: ' > log.txt
cat versionlog.txt >> log.txt
echo >> log.txt
cat description.txt >> log.txt

# do the git commit and tag
git config user.email "sdk@twitch.tv"
git config user.name "SDK Release Bot"
git commit -F log.txt
git tag -m 'Build Release' -a `cat versionlog.txt`

rm versionlog.txt

git push
git push --tags
