#!/bin/sh
#
# Copies the Mac binaries and samples to the release repo, commits and pushes.
# Initial directory: build/releasescripts
#
# workspace/
#     release/
#         build/
#             <master repo>
#         release-bins/
#             <binary release repo>
#         release-code/
#             <code release repo>

# Capture paths
cd ../../release-bins
BIN_REPO_DIR=$(pwd)
cd -

cd ../../release-code
SRC_RELEASE_REPO_DIR=$(pwd)
cd -

cd ..
SRC_REPO_DIR=$(pwd)
cd -

cd ..
SRC_LIB_DIR=$SRC_REPO_DIR/twitchsdk/lib
cd -

# clean previous products
rm -rf $BIN_REPO_DIR/include
rm -rf $BIN_REPO_DIR/mac
rm -rf $BIN_REPO_DIR/ios
rm -rf $BIN_REPO_DIR/external
rm -rf $BIN_REPO_DIR/samples
rm -rf $BIN_REPO_DIR/twitchcore
rm -rf $BIN_REPO_DIR/twitchchat

# TODO: include should also contain twitchcore stuff

# create directories
mkdir $BIN_REPO_DIR/include
mkdir -p $BIN_REPO_DIR/twitchcore/include/twitchcore/types
mkdir -p $BIN_REPO_DIR/twitchchat/include/twitchchat
mkdir $BIN_REPO_DIR/ios
mkdir $BIN_REPO_DIR/mac
mkdir $BIN_REPO_DIR/external
mkdir $BIN_REPO_DIR/external/win32
mkdir $BIN_REPO_DIR/external/x64
mkdir $BIN_REPO_DIR/samples

# copy over CHANGES.md and README (potentially meaningless but also okay)
cp $SRC_REPO_DIR/twitchsdk/CHANGES.md $BIN_REPO_DIR/CHANGES.md

# copy over the sample projects (once again, potentially meaningless)
cp -r $SRC_REPO_DIR/twitchsdk/samples/* $BIN_REPO_DIR/samples/

# want to make sure not to copy over setupsamples.bat as that is
# an internal only tool (and it wont even work in twitchrelease)
rm $BIN_REPO_DIR/samples/setupsamples.bat

# setup the include directory
cp $SRC_REPO_DIR/twitchsdk/include/* $BIN_REPO_DIR/include/
cp $SRC_REPO_DIR/twitchsdk/twitchcore/include/twitchcore/types/* $BIN_REPO_DIR/twitchcore/include/twitchcore/types/
cp $SRC_REPO_DIR/twitchsdk/twitchchat/include/twitchchat/chattypes.h $BIN_REPO_DIR/twitchchat/include/twitchchat/chattypes.h

# grab version.h from the master repo since it contains the proper version
cp $SRC_RELEASE_REPO_DIR/include/version.h $BIN_REPO_DIR/include/version.h

# setup the mac directory
cp -r $SRC_LIB_DIR/macosx/* $BIN_REPO_DIR/mac/

# setup the ios directory
cp -r $SRC_LIB_DIR/iphoneos/* $BIN_REPO_DIR/ios/

# setup the bin directory
# TODO: This should be part of winrelease.bat
for dir in ffmpeg libmp3lame intel
do
    cp -r $SRC_REPO_DIR/twitchsdk/$dir/bin/win32/* $BIN_REPO_DIR/external/win32/
    cp -r $SRC_REPO_DIR/twitchsdk/$dir/bin/x64/* $BIN_REPO_DIR/external/x64/
done

# push to git
cd $BIN_REPO_DIR

COMMITMESSAGE=$(git --git-dir $SRC_RELEASE_REPO_DIR/.git describe --abbrev=0 --tags)
COMMITMESSAGE="Twitch Release (OSX Build): $COMMITMESSAGE"
git add -A
git config user.email sdk@twitch.tv
git config user.name 'SDK Release Bot'
git commit -m "$COMMITMESSAGE"
git push

cd -
