::  Used by: release-win-bins builder, mock-release-win-bins builder
::
:: Takes the build products from relevant platforms and packages them into a 
:: distributable Java plugin.
::
:: This script assumes that the current directory is the Java sample root.

@echo on

:: Capture paths
pushd %CD%\..\..\bindings
if NOT exist "%CD%\bin" ( mkdir "%CD%\bin" )
cd bin
if NOT exist "%CD%\java" ( mkdir "%CD%\java" )
cd java
set PACKAGE_DIR=%CD%
echo PACKAGE_DIR=%PACKAGE_DIR%
popd

pushd "%CD%\..\..\bindings\java"
set WRAPPER_SRC_DIR=%CD%\src
set WRAPPER_BIN_DIR=%CD%\bin
echo WRAPPER_SRC_DIR=%WRAPPER_SRC_DIR%
echo WRAPPER_BIN_DIR=%WRAPPER_BIN_DIR%
popd

pushd %CD%\..\..\lib
set TWITCH_LIB_DIR=%CD%
echo TWITCH_LIB_DIR=%TWITCH_LIB_DIR%
popd

:: Compile Java wrapper classes
if exist "%CD%\..\..\bindings\java\bin" ( rmdir /Q /S "%CD%\..\..\bindings\java\bin" )
mkdir "%CD%\..\..\bindings\java\bin"
"%JAVA_HOME%\bin\javac.exe" -d "%WRAPPER_BIN_DIR%" %WRAPPER_SRC_DIR%\tv\twitch\*.java %WRAPPER_SRC_DIR%\tv\twitch\broadcast\*.java %WRAPPER_SRC_DIR%\tv\twitch\chat\*.java
if %errorlevel% neq 0 exit /b %errorlevel%

:: Create the JAR
"%JAVA_HOME%\bin\jar" -cfv "%PACKAGE_DIR%\TwitchJava.jar" -C "%WRAPPER_BIN_DIR%" .
if %errorlevel% neq 0 exit /b %errorlevel%

:: Copy the Windows native libraries
set DEST=%PACKAGE_DIR%\x86
if NOT exist "%DEST%" ( mkdir %DEST% )
copy /B "%TWITCH_LIB_DIR%\Win32\ReleaseBindings\twitchsdk.dll" "%DEST%\twitchsdk.dll" /Y

set DEST=%PACKAGE_DIR%\x64
if NOT exist "%DEST%" ( mkdir %DEST% )
copy /B "%TWITCH_LIB_DIR%\x64\ReleaseBindings\twitchsdk.dll" "%DEST%\twitchsdk.dll" /Y

:: Copy Mac dylib to Java natives directory
set DEST=%PACKAGE_DIR%\mac
if NOT exist "%DEST%" ( mkdir %DEST% )
copy /B "%TWITCH_LIB_DIR%\macosx\Release\libtwitchsdk.dylib" "%DEST%\libtwitchsdk.dylib" /Y

:: Package the controller and sample source file
set DEST=%PACKAGE_DIR%\src
if NOT exist "%DEST%" ( mkdir %DEST% )
xcopy %CD%\gears\project\src\* %DEST% /S /Y
