::  Used by: release-win-bins builder, mock-release-win-bins builder
::
:: Takes the build products from relevant platforms and packages them into a 
:: distributable Unity plugin.
::
:: This script assumes that the current directory is the Unity project root.
:: It also does a some hacky waiting for Unity to finish.  Unity is really sensitive to 
:: starting too quickly after a previous run on the command line.  The waits below 
:: might seem excessive but it's the only thing that seems to keep Unity from complaining.

:: Capture paths
pushd %CD%\..\..\bindings
if NOT exist "%CD%\bin" ( mkdir "%CD%\bin" )
cd bin
if NOT exist "%CD%\unity" ( mkdir "%CD%\unity" )
cd unity
set PACKAGE_DIR=%CD%
echo PACKAGE_DIR=%PACKAGE_DIR%
popd

:: Wait for previous run of Unity to terminate
:WAIT_FOR_UNITY_SHUTDOWN
ping -n 5 127.0.0.1 > nul
tasklist /FI "IMAGENAME eq Unity.exe" 2>NUL | find /I /N "Unity.exe">NUL
if "%ERRORLEVEL%"=="0" (
	echo Unity is running, waiting for shutdown
	goto :WAIT_FOR_UNITY_SHUTDOWN
)

:: Copy TwitchSdkWrapper.dll manually so there are no script compiler errors when starting Unity
copy /B "..\..\bindings\csharp\wrapper\bin\AnyCPU\Release\TwitchSdkWrapper.dll" "./Assets/Plugins/TwitchSdkWrapper.dll" /Y

:: Copy Mac bundle to Unity plugins directory
set DEST=%CD%"\Assets\Plugins\twitchsdk.bundle\"
if exist "%DEST%" ( rmdir /Q /S "%DEST%" )
xcopy "..\..\lib\macosx\Release\twitchsdk.bundle" "%DEST%" /S /Y

:: Run Unity in batch mode to generate the .unitypackage
if exist "%CD%\Library" ( rmdir /Q /S "%CD%\Library" )
if exist "%CD%\Temp" ( rmdir /Q /S "%CD%\Temp" )
ping -n 3 127.0.0.1 > nul
"C:\Program Files (x86)\Unity\Editor\Unity.exe" -batchmode -nographics -quit -projectPath "%CD%" -executeMethod Twitch.TwitchEditor.ExportPackageFromCommandLine "%PACKAGE_DIR%/TwitchUnity.unitypackage"

:: Report a failure
if %errorlevel% neq 0 (
	echo Failed to build Twitch.unitypackage.  Unity Editor.log:
	echo

	:: Dump the editor log for details
	type %userprofile%\AppData\Local\Unity\Editor\Editor.log
	
	:: Exit with an error code
	exit /b %errorlevel%

) else (
	echo Twitch.unitypackage build successfully.
)
