::  Used by: release-win-bins builder, mock-release-win-bins builder
::
:: Takes the build products from relevant platforms and packages them into a 
:: distributable XNA plugin.
::
:: This script assumes that the current directory is the XNA sample root.

:: Capture paths
pushd %CD%\..\..\bindings
if NOT exist "%CD%\bin" ( mkdir "%CD%\bin" )
cd bin
if NOT exist "%CD%\xna" ( mkdir "%CD%\xna" )
cd xna
set PACKAGE_DIR=%CD%
echo PACKAGE_DIR=%PACKAGE_DIR%
popd

pushd %CD%\..\..\lib
set TWITCH_LIB_DIR=%CD%
echo TWITCH_LIB_DIR=%TWITCH_LIB_DIR%
popd

pushd %CD%\..\unity\Assets\Twitch\Scripts
set UNITY_SRC_DIR=%CD%
echo UNITY_SRC_DIR=%UNITY_SRC_DIR%
popd

:: Copy C# wrapper library
set DEST=%PACKAGE_DIR%
copy /B "..\..\bindings\csharp\wrapper\bin\AnyCPU\Release\TwitchSdkWrapper.dll" "%DEST%\TwitchSdkWrapper.dll" /Y

:: Copy the Windows native libraries
set DEST=%PACKAGE_DIR%\x86
if NOT exist "%DEST%" ( mkdir %DEST% )
copy /B "%TWITCH_LIB_DIR%\Win32\ReleaseBindings\twitchsdk.dll" "%DEST%\twitchsdk.dll" /Y

set DEST=%PACKAGE_DIR%\x64
if NOT exist "%DEST%" ( mkdir %DEST% )
copy /B "%TWITCH_LIB_DIR%\x64\ReleaseBindings\twitchsdk.dll" "%DEST%\twitchsdk.dll" /Y

:: Package the controllers and sample source file
set DEST=%PACKAGE_DIR%\src
if NOT exist "%DEST%" ( mkdir %DEST% )
xcopy %UNITY_SRC_DIR%\BroadcastController.cs %DEST% /S /Y
xcopy %UNITY_SRC_DIR%\ChatController.cs %DEST% /S /Y
xcopy %UNITY_SRC_DIR%\IngestTester.cs %DEST% /S /Y
xcopy %CD%\XnaBroadcastController.cs %DEST% /S /Y
xcopy %CD%\Game1.cs %DEST% /S /Y

:DONE
