:: Clones the given repo if it doesn't exist and pulls latests.
:: Initial directory: build/releasescripts
:: Arguments:
::   1: The repo url.
::   2: The repo dir.
::
:: workspace/
::     release/
::         build/
::             <master repo>
::         release-bins/
::             <binary release repo>
::         release-code/
::             <code release repo>


set REPO_URL=%1%
set REPO_DIR=%2%

cd ..\..

:: Clone the repo if it doesn't exist
if not exist "%REPO_DIR%" (
	git clone "%REPO_URL%" "%REPO_DIR%"
)
if %errorlevel% neq 0 exit /b %errorlevel%

:: Delete the lock file if it exists from a previously failed build
set LOCK_FILE="%REPO_DIR%\.git\index.lock"
if exist "%LOCK_FILE%" (
	del "%LOCK_FILE%" /q /f
)

:: Pull latest from the repo
cd %REPO_DIR%
git reset --hard
git pull
if %errorlevel% neq 0 exit /b %errorlevel%
