#!/bin/sh
#
# Clones the given repo if it doesn't exist and pulls latests.
# Initial directory: build/releasescripts
# Arguments:
#   1: The repo url.
#   2: The repo dir.
#
# workspace/
#     release/
#         build/
#             <master repo>
#         release-bins/
#             <binary release repo>
#         release-code/
#             <code release repo>


REPO_URL=$1
REPO_DIR=$2

cd ../..

# Clone the repo if it doesn't exist
if [ ! -d "$REPO_DIR/.git" ]; then
	git clone "$REPO_URL" "$REPO_DIR"
fi

# Delete the lock file if it exists from a previously failed build
rm "$REPO_DIR/.git/index.lock"

# Pull latest from the repo
cd $REPO_DIR
git reset --hard
git pull
