#!/bin/sh
# used by release, mock-release builders. See master.cfg's setup_release_factory.
#
# Updates the version.h header file by updating the minor version number
# and updating the version identifier string.
#
# Works under the assumption there exists some old.version.h file in the
# include directory that is the state of version.h in the previous release

cd ../twitchsdk/include
if [ -f old.version.h ]
then
    # check if major version number has updated
    if diff version.h old.version.h | grep kMajorVersion
    then
        # if so, set minor version to 0, use new major version number
        perl -pe 's/(const int kMinorVersion = )(\d+)/$1 . 0/eg' version.h > updated.version.h
    else
        # if not, increment minor on previous version, use previous major
        perl -pe 'BEGIN { sub incrementor { my ($num) = @_; ++$num } } s/(const int kMinorVersion = )(\d+)/$1 . (incrementor($2))/eg' old.version.h > updated.version.h
    fi

    mv updated.version.h version.h
    rm old.version.h
fi

# Now update the version identifier string. We can ask the parent-most
# directory for the commit hash of sdk's release branch because of
# how master.cfg nests git repos.
IDENTIFIER=$(git --git-dir ../../.git rev-parse --short HEAD)
IDENTIFIER="\"$IDENTIFIER\""
awk -v ttvid="$IDENTIFIER" '/kVersionIdentifier = /{gsub(/".*"/, ttvid)};{print}' version.h > updated.version.h
mv updated.version.h version.h

cd ..
