::
:: Copies the Windows binaries to the release repo, commits and pushes.
:: Makes the assumption that git bash commands are available from the command prompt.
:: Assumes the binaries and packages have already been built.
:: Initial directory: build/releasescripts
::
:: workspace/
::     release/
::         build/
::             <master repo>
::         release-bins/
::             <binary release repo>
::         release-code/
::             <code release repo>

pushd %CD%

:: Capture paths
pushd %CD%\..\..\release-bins
set BINS_REPO_DIR=%CD%
echo BINS_REPO_DIR=%BINS_REPO_DIR%
popd

pushd %CD%\..\..\release-code
set SRC_RELEASE_REPO_DIR=%CD%
echo SRC_RELEASE_REPO_DIR=%SRC_RELEASE_REPO_DIR%
popd

pushd ..\twitchsdk\lib
set SRC_LIB_DIR=%CD%
echo SRC_LIB_DIR=%SRC_LIB_DIR%
popd

pushd %BINS_REPO_DIR%\lib
set DEST_LIB_DIR=%CD%
echo DEST_LIB_DIR=%DEST_LIB_DIR%
popd

:: Remove all previous files
rm %DEST_LIB_DIR%/*

:: Copy the native libraries
if NOT exist "%DEST_LIB_DIR%" ( mkdir "%DEST_LIB_DIR%" )
cp %SRC_LIB_DIR%/* %DEST_LIB_DIR%/

:: remove ilk and exp files, we don't want them
rm %DEST_LIB_DIR%/*.ilk
rm %DEST_LIB_DIR%/*.exp

:: push to git. Annoying, but have to make a temp file for commit message
:: because of the semantics of bat scripts
cd %BINS_REPO_DIR%

if exist "log.txt" ( rm "log.txt" )

call git pull
call git add -A

env echo -n 'Twitch Release (Win Build): ' > log.txt
call git --git-dir %SRC_RELEASE_REPO_DIR%/.git describe --abbrev=0 --tags >> log.txt
if %errorlevel% neq 0 exit /b %errorlevel%

call git config user.email sdk@twitch.tv
call git config user.name "SDK Release Bot"
call git commit -F log.txt
if %errorlevel% neq 0 exit /b %errorlevel%
call git push
if %errorlevel% neq 0 exit /b %errorlevel%

rm log.txt

popd
