/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2014 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#include "twitchcore\isocket.h"

namespace ttv
{
	class WiresharkReplaySocket;
}

class ttv::WiresharkReplaySocket : public ISocket
{
public:
	WiresharkReplaySocket();
	virtual ~WiresharkReplaySocket();

	// ISocket Implementation
	virtual TTV_ErrorCode ConnectTo(const std::string& host, const std::string& port);
	virtual TTV_ErrorCode Disconnect();
	virtual TTV_ErrorCode TCPListen(const std::string& host, const std::string& port);
	virtual TTV_ErrorCode AcceptConnection(/*outParam*/ ISocket** newSocket);
	virtual TTV_ErrorCode Send(const uint8_t* buffer, size_t length, bool cache);
	virtual TTV_ErrorCode Recv(uint8_t* buffer, size_t length, size_t& received, bool fillBuffer);
	virtual TTV_ErrorCode FlushCache();
	virtual TTV_ErrorCode SetBlockingMode(bool blockingMode);
	virtual uint64_t TotalSent() const;
	virtual uint64_t TotalReceived() const;
	virtual bool Connected();

private:
	uint64_t mTotalSent;
	uint64_t mTotalRecieved;
	uint32_t mNextInputPacket;
	size_t mNextInputOffset;
	uint32_t mNextOutputPacket;
	uint64_t mConnectTime;
	bool mBlocking;
	bool mConnected;
};
