package fruit

import "fmt"

// NotFoundError returned when Get is called with a non-existant fruit
type NotFoundError struct {
	ID string
}

func (f NotFoundError) Error() string {
	return fmt.Sprintf("fruit not found: %s", f.ID)
}

// Fruit represents a fruit with a price
type Fruit struct {
	ID    string
	Price int
}
