package fruitinmemory

import (
	"testing"

	"code.justin.tv/security-cop/fruit"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestFruits(t *testing.T) {
	t.Run("Get not found", func(t *testing.T) {
		f := New()
		_, err := f.Get("my-id")
		assert.Equal(t, fruit.NotFoundError{ID: "my-id"}, err)
		assert.Equal(t, "fruit not found: my-id", err.Error())
	})

	t.Run("UpdatePrice and get", func(t *testing.T) {
		f := New()
		require.NoError(t, f.UpdatePrice("my-id", 420))
		item, err := f.Get("my-id")
		require.NoError(t, err)
		assert.Equal(t, &fruit.Fruit{ID: "my-id", Price: 420}, item)
	})
}
