package main

import (
	"flag"
	"log"
	"net/http"

	"code.justin.tv/security-cop/graphql-demo/data"
	"code.justin.tv/security-cop/graphql-demo/resolver"
	"github.com/graph-gophers/graphql-go"
	"github.com/graph-gophers/graphql-go/relay"
)

func main() {
	listener := flag.String("l", "127.0.0.1:42560", "net listener to use")
	flag.Parse()

	schema := graphql.MustParseSchema(string(schema), resolver.NewResolver(
		data.Comments,
		data.Posts,
		data.SponsoredPosts,
		data.TimelineEntries,
		data.Users,
	))

	http.Handle("/graphql", &relay.Handler{Schema: schema})
	http.Handle("/", &graphiQL{})
	log.Printf("listening on %s", *listener)
	log.Fatal(http.ListenAndServe(*listener, nil))
}
