package resolver

import (
	"github.com/graph-gophers/graphql-go"
)

// PostFields ...
type PostFields struct {
	ID       graphql.ID
	Author   graphql.ID
	Content  string
	Comments []graphql.ID
}

type post struct {
	fields   PostFields
	comments commentsAPI
	users    usersAPI
}

func (p post) ID() graphql.ID {
	return p.fields.ID
}

func (p post) Content() string {
	return p.fields.Content
}

func (p post) Author() *user {
	if author, ok := p.users.Get(p.fields.Author); ok {
		return author
	}
	return nil
}

func (p post) Comments(in struct {
	First int32
}) []*comment {
	comments := p.fields.Comments
	if len(comments) > int(in.First) {
		comments = comments[:in.First]
	}
	res := make([]*comment, len(comments))
	for nComment, commentID := range comments {
		if comment, ok := p.comments.Get(commentID); ok {
			res[nComment] = comment
		}
	}
	return res
}
