package resolver

import (
	"github.com/graph-gophers/graphql-go"
)

// SponsoredPostFields ...
type SponsoredPostFields struct {
	ID       graphql.ID
	Sponsor  graphql.ID
	Comments []graphql.ID
	Content  string
}

type sponsoredPost struct {
	fields   SponsoredPostFields
	comments commentsAPI
	users    usersAPI
}

func (p sponsoredPost) ID() graphql.ID {
	return p.fields.ID
}

func (p sponsoredPost) Content() string {
	return p.fields.Content
}

func (p sponsoredPost) Sponsor() *user {
	if author, ok := p.users.Get(p.fields.Sponsor); ok {
		return author
	}
	return nil
}

func (p sponsoredPost) Comments(in struct {
	First int32
}) []*comment {
	comments := p.fields.Comments
	if len(comments) > int(in.First) {
		comments = comments[:in.First]
	}
	res := make([]*comment, len(comments))
	for nComment, commentID := range comments {
		if comment, ok := p.comments.Get(commentID); ok {
			res[nComment] = comment
		}
	}
	return res
}
