package resolver

import (
	"testing"

	"github.com/graph-gophers/graphql-go"
	"github.com/stretchr/testify/assert"
)

func TestSponsoredPost(t *testing.T) {
	const id = "id"
	const content = "content"
	const sponsorID = "sponsorid"
	const commentID = "commentid"

	comments := new(mockCommentsAPI)
	users := new(mockUsersAPI)
	p := &sponsoredPost{
		fields: SponsoredPostFields{
			ID:       graphql.ID(id),
			Sponsor:  graphql.ID(sponsorID),
			Content:  content,
			Comments: []graphql.ID{commentID},
		},
		comments: comments,
		users:    users,
	}

	assert.Equal(t, graphql.ID(id), p.ID())
	assert.Equal(t, content, p.Content())

	t.Run("Sponsor", func(t *testing.T) {
		t.Run("present", func(t *testing.T) {
			u := &user{fields: UserFields{ID: sponsorID}}
			users.On("Get", graphql.ID(sponsorID)).Return(u, true).Once()
			defer users.AssertExpectations(t)

			assert.Equal(t, u, p.Sponsor())
		})

		t.Run("missing", func(t *testing.T) {
			users.On("Get", graphql.ID(sponsorID)).Return(nil, false).Once()
			defer users.AssertExpectations(t)

			assert.Nil(t, p.Sponsor())
		})
	})

	t.Run("Comments", func(t *testing.T) {
		c := &comment{fields: CommentFields{ID: commentID}}
		comments.On("Get", graphql.ID(commentID)).Return(c, true).Once()
		defer comments.AssertExpectations(t)

		assert.Equal(t, []*comment{c}, p.Comments(struct {
			First int32
		}{First: 10}))
	})
}
