package cache_test

import (
	"fmt"
	"testing"

	"code.justin.tv/security-copy/performant-go/cache"
)

func BenchmarkAdd1(b *testing.B) {
	for i := 0; i < b.N; i++ {
		sc := cache.NewStringCache()
		for nItem := 0; nItem < 1; nItem++ {
			sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
		}
	}
}

func BenchmarkAdd10(b *testing.B) {
	for i := 0; i < b.N; i++ {
		sc := cache.NewStringCache()
		for nItem := 0; nItem < 10; nItem++ {
			sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
		}
	}
}

func BenchmarkAdd100(b *testing.B) {
	for i := 0; i < b.N; i++ {
		sc := cache.NewStringCache()
		for nItem := 0; nItem < 100; nItem++ {
			sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
		}
	}
}

func BenchmarkAdd1000(b *testing.B) {
	for i := 0; i < b.N; i++ {
		sc := cache.NewStringCache()
		for nItem := 0; nItem < 1000; nItem++ {
			sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
		}
	}
}

func BenchmarkFetchFrom1(b *testing.B) {
	sc := cache.NewStringCache()
	for nItem := 0; nItem < 1; nItem++ {
		sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
	}
	for i := 0; i < b.N; i++ {
		sc.Fetch(fmt.Sprintf("key-0"))
	}
}

func BenchmarkFetchFrom10(b *testing.B) {
	sc := cache.NewStringCache()
	for nItem := 0; nItem < 10; nItem++ {
		sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
	}
	for i := 0; i < b.N; i++ {
		sc.Fetch(fmt.Sprintf("key-9"))
	}
}

func BenchmarkFetchFrom100(b *testing.B) {
	sc := cache.NewStringCache()
	for nItem := 0; nItem < 100; nItem++ {
		sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
	}
	for i := 0; i < b.N; i++ {
		sc.Fetch(fmt.Sprintf("key-99"))
	}
}

func BenchmarkFetchFrom1000(b *testing.B) {
	sc := cache.NewStringCache()
	for nItem := 0; nItem < 1000; nItem++ {
		sc.Add(fmt.Sprintf("key-%d", nItem), fmt.Sprintf("value-%d", nItem))
	}
	for i := 0; i < b.N; i++ {
		sc.Fetch(fmt.Sprintf("key-999"))
	}
}
