import * as React from "react";

import { ApolloProvider } from "react-apollo";
import { ApolloClient } from "apollo-client";
import { HttpLink } from "apollo-link-http";
import { InMemoryCache, NormalizedCacheObject } from "apollo-cache-inmemory";
import PostsContainer from "./containers/PostsContainer"

const cache = new InMemoryCache();
const link = new HttpLink({ uri: '/graphql' });
const client: ApolloClient<NormalizedCacheObject> = new ApolloClient({ cache, link });

export const FancyWithGraphql = () => (
    <ApolloProvider client={client}>
        <PostsContainer />
    </ApolloProvider>
)