import * as React from "react";
import gql from "graphql-tag";
import { ChildDataProps, graphql } from "react-apollo";

import { Accordion } from "twitch-core-ui";

const POSTS_QUERY = gql`
    query PostsQuery($first: Int, $after: ID) {
        posts(first: $first, after: $after) {
            id 
            content
            author {
                id
                name
            }
        }
    }
`
  
type Variables = {
    first: number;
    after: string;
};
  
type Response = {
    posts: Post[];
};

interface Post {
    id: string;
    content: string;
    author: User;
}

interface User {
    id: string;
    name: string;
}

type ChildProps = ChildDataProps<{}, Response, Variables>;

const withPosts = graphql<{}, Response, Variables, ChildProps>(POSTS_QUERY, {
    options: () => ({
        variables: {
            first: 10,
            after: null
        }
    })
});

export default withPosts(({
    data: { loading, posts, error }
}) => {
    if (loading) return <div>Loading</div>;
    if (error) return <h1>{error.message}</h1>;
    return <Accordion
        items={posts.map((post) => (
            {
                header: { title: "A Post", description: `By ${post.author.name}` },
                body: { children: post.content },
            }
        ))}
    />
});