import { CfnInitConfig } from ".";
import path = require('path');
import fs = require('fs');

/**
 * Run a script to report docker disk usage metrics
 */
export function dockerDiskMetrics(): CfnInitConfig {
  return {
    onLaunch: {
      name: 'install-docker-disk-metrics-dependencies',
      commands: [{
        name: 'install-aws-cli',
        command: 'yum -qy -d 0 -e 0 install aws-cli',
      }, {
        name: 'install-jq',
        command: 'yum -qy -d 0 -e 0 install jq',
      }]
    },
    always: {
      name: "report-docker-disk-metrics",
      files: [
        {
          path: '/usr/local/bin/docker-disk-metrics.sh',
          content: fs.readFileSync(path.join(__dirname, 'docker-disk-metrics.sh'), 'utf-8'),
          mode: '000755',
        },
        {
          path: '/etc/cron.d/docker-disk-metrics',
          content: '*/5 * * * * root /usr/local/bin/docker-disk-metrics.sh >> /var/log/docker-disk-metrics.log 2>&1\n',
          mode: '000644',
        },
      ],
    },
  };
}
