import * as path from "path";
import * as archiver from "archiver";
import * as fs from "fs";
import * as packlist from "npm-packlist";

function zipFiles(
  files: string[],
  source: string,
  outputFile: string
): Promise<void> {
  return new Promise((resolve, reject): void => {
    const output = fs.createWriteStream(outputFile);
    output.once("close", resolve);

    const archive = archiver("zip");
    archive.on("warning", reject);
    archive.on("error", reject);

    files.forEach(file => {
      const filePath = path.join(source, file);
      archive.file(filePath, { name: file });
    });

    archive.pipe(output);
    archive.finalize();
  });
}

async function packDirectory(
  sourcePath: string,
  outputFile: string
): Promise<void> {
  const files = await packlist({ path: sourcePath });
  return zipFiles(files, sourcePath, outputFile);
}

packDirectory(
  __dirname,
  path.join(__dirname, "bundle.zip"),
);
