import { expect as expectCDK, haveResource, NegatedAssertion, SynthUtils } from '@aws-cdk/assert';
import * as cdk from '@aws-cdk/core';
import * as spade from '../lib/index';

test('Minimal config snapshot', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'TestStack');
    new spade.KinesisStream(stack, 'MyTestConstruct', {
      alarmsEnabled: true,
      shardCount: 1,
      streamName: 'spade-downstream-prod-twitch-ce-analytics-prod-us-west-2-my-specific-stream',
    });
    expect(SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});

test('Enabling alarms', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'TestStack');
    new spade.KinesisStream(stack, 'MyTestConstruct', {
      alarmsEnabled: true,
      shardCount: 1,
      streamName: 'spade-downstream-prod-twitch-ce-analytics-prod-us-west-2-my-specific-stream',
    });
    expectCDK(stack).to(haveResource('AWS::CloudWatch::Alarm', {
      ActionsEnabled: true,
    }));
    expectCDK(stack).to(new NegatedAssertion(haveResource('AWS::CloudWatch::Alarm', {
      ActionsEnabled: false,
    })));
});

test('Disabling alarms', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'TestStack');
    new spade.KinesisStream(stack, 'MyTestConstruct', {
      alarmsEnabled: false,
      shardCount: 1,
      streamName: 'spade-downstream-prod-twitch-ce-analytics-prod-us-west-2-my-specific-stream',
    });
    expectCDK(stack).to(haveResource('AWS::CloudWatch::Alarm', {
      ActionsEnabled: false,
    }));
    expectCDK(stack).to(new NegatedAssertion(haveResource('AWS::CloudWatch::Alarm', {
      ActionsEnabled: true,
    })));
});
