import json
import logging
import os
import time

import boto3

logger = logging.getLogger()
logger.setLevel(logging.INFO)
logging.getLogger("boto3").setLevel(logging.WARNING)
logging.getLogger("botocore").setLevel(logging.WARNING)


def handler(event, context):
    """Obtains the Redshift Leader IP"""
    resp = {
        "PhysicalResourceId": context.log_stream_name,
        "Data": {
            "leaderIP": "unknown"
        }
    }

    if event['RequestType'] == 'Delete':
        return

    cluster_id = event['ResourceProperties']['RedshiftClusterId']
    clusters = boto3.client("redshift").describe_clusters(
        ClusterIdentifier=cluster_id)['Clusters']

    if len(clusters) != 1:
        raise Exception('Invalid number of clusters: %s' % clusters)

    nodes = clusters[0].get('ClusterNodes', [])
    for node in nodes:
        if node.get('NodeRole') == 'LEADER':
            logger.info('leader ip is %s', str(node.get('PrivateIPAddress')))
            resp['Data']['leaderIP'] = node.get('PrivateIPAddress')
        return resp
