export { Connection } from './connection';
export { EndpointService } from './endpoint-service';
export { Registration } from './registration';

export interface TahoeStage {
  account: string;
  apiInvocationRoleArn: string;
  loggingBucketName: string;
}

export const TahoeBeta: TahoeStage = {
  account: '253715324151',
  apiInvocationRoleArn: 'arn:aws:iam::253715324151:role/TwitchTahoeAPILambda-TapInvokerRole-QMGC49RDNVIY',
  loggingBucketName: 'tahoe-tap-logs-253715324151',
};

export const TahoeProd: TahoeStage = {
  account: '331582574546',
  apiInvocationRoleArn: 'arn:aws:iam::331582574546:role/TwitchTahoeAPILambda-TapInvokerRole-1GFJM9XKMTVUV',
  loggingBucketName: 'tahoe-tap-logs-331582574546',
};
