import * as cdk from '@aws-cdk/core';
import { ResourceHandler } from './resource-handler';

export interface SubscriptionListProps {
  tapId: string;
  views: Array<string>;
}

export class SubscriptionList extends cdk.Construct {
  constructor(scope: cdk.Construct, id: string, props: SubscriptionListProps) {
    super(scope, id);

    const handler = new ResourceHandler(this, 'SubsHandler')

    new cdk.CustomResource(this, 'Resource', {
      serviceToken: handler.serviceToken,
      properties: {
        CustomResource: 'SubscriptionList',
        TapId: props.tapId,
        Views: props.views,
      },
    });
  }
}
