import { countResources, expect as expectCDK } from '@aws-cdk/assert';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as redshift from '@aws-cdk/aws-redshift';
import * as cdk from '@aws-cdk/core';
import * as TahoeTap from '../lib';
import { TapRoles } from '../lib/roles';

/*
 * Example test 
 */
test('SNS Topic Created', () => {
  const app = new cdk.App();
  const stack = new cdk.Stack(app, "TestStack");
  // WHEN
  const vpc = new ec2.Vpc(stack, 'VPC');
  const cluster = new redshift.Cluster(stack, 'Tahoe', {
    vpc,
    masterUser: {
      masterUsername: 'tahoe',
    },
  });
  new TahoeTap.Registration(stack, 'MyTestConstruct', {
    cluster,
    bindleId: 'amzn1.bindle.resource.ABCDEfghij1234567890',
    purpose: 'blah',
    endpointServiceName: 'service-name',
    roles: new TapRoles(stack, 'Roles', {
      secret: cluster.secret!,
    }),
    tapName: 'foo',
  });
  // THEN
  expectCDK(stack).to(countResources("AWS::SNS::Topic",0));
});
