# Meepo

Meepo is Squad Streaming's backend service.  Squad Streaming allows up to four broadcasters to stream together.

  * [Design](https://amazon.invisionapp.com/boards/PH3MSJUTNX9) (Password: squad)
  * [Product Spec](https://docs.google.com/document/d/1JP2ePBvEYBE1t3aArbjN0UviHbQkBd5rnlHQHbpQRYM/)  
  * [Tech Spec](https://docs.google.com/document/d/1H0atPeLOG76wfjrjtyV55c0gIs9Zp4ay3qov0cgsepk/edit?usp=sharing)
  * [Threat Model](https://docs.google.com/document/d/1Dln5YgJVmDLHal0X8JQs24-zwU95Gmw0HZ7NZGRPLlA/edit?usp=sharing)

## Table of Contents

- [Getting Started](#getting-started)
  - [Setup](#setting-up)
  - [Generating Clients](#generating-clients)
  - [Running Tests](#running-integration-tests)
  - [DB Migrations](#db-migrations)
- [Key/Value Store](#key-value-store)
  - [Modifying Values](#modifying-values)
- [Service Level Agreement](#service-level-agreement)
- [Contributing and Deployment](#deployment)
- [Troubleshooting and recovery](#troubleshooting-and-recovery)
  - [Error Logs](#error-logs)
  - [Rollback Meepo](#rollback-meepo)
  - [Database Recovery](#database-recovery)
- [Contact us](#contact-us)
- [Service links](#service-links)

## Getting Started

### Setting Up

This service depends on [Go](https://golang.org/doc/install) and [Protocol Buffers](https://github.com/protocolbuffers/protobuf).
Verify that Go and Protocol Buffers is avaliable by typing `go` and `protoc` in the command line.

> Note: Set up [$GOPATH](https://golang.org/doc/code.html#GOPATH) to your desired location. Make sure to also add to PATH `$GOPATH/bin`
by adding `export PATH=$GOPATH/bin:$PATH` to your `.bash_profile`.

```bash
> cd $GOPATH/src/code.justin.tv/twitch-events/meepo
> make setup
> make update
```

### Generating Clients

After making changes to `/rpc/*.proto` files, clients can be re-generated by running:

```bash
> make rpc
```

### Running Integration Tests

Local integration tests are run against the Meepo `staging` database.

Running tests require that you have an IAM user in the `twitch-feed-dev` AWS account. Once you have
are IAM user in the account:
  1. Install [`aws-cli`](https://docs.aws.amazon.com/cli/latest/userguide/installing.html)
  2. Follow instructions on this [page](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html) to setup
     access keys for your IAM user
  3. Configure the `aws-cli` with a user profile `twitch-feed-dev` with access and secret keys
     created in the previous step


Run integration tests with the command:

```bash
> AWS_PROFILE=twitch-feed-dev make integration_test

```

Run integration tests without cache:

```bash
> AWS_PROFILE=twitch-feed-dev make integration_test_no_cache

```

### DB Migrations

To make modifications to Meepo's RDS database, see [DB Migrations](./docs/db_migrations.md).

## Key Value Store

Meepo stores key/values that it uses:
  1. [Locally](https://git.xarth.tv/twitch-events/meepo/tree/master/config) for static values that do not frequently change
  2. [AWS Parameter Store](https://git.xarth.tv/twitch-events/meepo/blob/master/terraform/parameters/main.tf) managed with Terraform, for dynamic values that is often updated

### Modifying Values

  - Locally in [JSON](https://git.xarth.tv/twitch-events/meepo/tree/master/config)
    - Locate the environment and key that you would like the value changed
    - Make changes to JSON
    - Submit a PR, and request a review
  - AWS Parameter Store via [Terraform](https://git.xarth.tv/twitch-events/meepo/blob/master/terraform/parameters/main.tf)
    - Locate the environment and key that you would like the value changed
    - Make changes to the Terraform file
    - Submit a PR, request a review, and also include whether you would also like review to apply the changes to the AWS Parameter Store
    - Once approved, if not yet applied to AWS Parameter Store; run `terraform plan` and `terraform apply` in this [directory](https://git.xarth.tv/twitch-events/meepo/blob/master/terraform/parameters)

## Service Level Agreement

[SLA](./docs/service_level_agreement.md)

## Deployment

*Contributing:*

- [ ] Commit changes to a feature branch, make a PR and wait for [PR approval](https://twitch.slack.com/messages/creator-discovery)
- [ ] Make sure all checks have passed and your branch is up-to-date with `master`
- [ ] Merge feature branch into `master`

*Deploying:*

- [ ] Navigate to [Clean-Deploy](https://deploy.xarth.tv/#/twitch-events/meepo)
- [ ] Deploy `master` to `staging`
- [ ] Monitor [`staging`](https://grafana.xarth.tv/d/MUrsdCdmk/meepo?orgId=1&var-env=staging) Grafana for a little while to verify that everything is normal as expected
- [ ] Wait for the deploy to `staging` to successfully complete, then deploy `master` to `production`
- [ ] Monitor [`production`](https://grafana.xarth.tv/d/MUrsdCdmk/meepo?orgId=1&var-env=production) Grafana for breakage and increased latencies

## Troubleshooting and Recovery

### Error Logs

Investigating an issue; **error logs** can be viewed on Rollbar:

- [	`staging`](https://rollbar.com/Twitch/Meepo/?environment=staging)
- [`production`](https://rollbar.com/Twitch/Meepo/?environment=production)

### Rollback Meepo

When we want to **rollback** to a previous commit:

- [ ] Navigate to environment of concern on Clean-Deploy, [`staging`](https://deploy.xarth.tv/#/twitch-events/meepo/history?env=staging) or [`production`](https://deploy.xarth.tv/#/twitch-events/meepo/history?env=production)
- [ ] From the UI, find the commit you wish to revert to
- [ ] Click `Redeploy` on the commit

### Database Recovery

In the event that the database needs to be **recovered** from a historic snapshot or restore point. The following steps can be taken to restore it. 

> Snapshots are created **once a day** at between 2-4am UTC. And restore points are created every **5 minutes**. Both are kept for **5 days**. [See also](https://aws.amazon.com/rds/faqs/#Automatic_Backups_and_Database_Snapshots)

- [ ] Navigate to the Meepo RDS AWS console
  - Sign in with the `twitch-feed-dev` account for [`staging`](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#database:id=events-meepo-staging;is-cluster=false)
  - Sign in with the `twitch-feed-aws` account for [`production`](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#database:id=events-meepo-production;is-cluster=false)
- [ ] Follow instructions below, starting from **step#4** to restore the database.

  > When filling out the field `DB Instance Identifier`, make sure added `-<environment>` as the suffix. For example, `my-new-instance-staging`.

  - From a [snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RestoreFromSnapshot.html)
  - From a [restore point](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html)
- [ ] Configure your new database with the following fields, the rest can be left as is:
  - [ ] `Multi-AZ Deployment: Yes`
- [ ] Run the the following commands from `meepo` root to update remote S3 Terraform state:

  ```bash
  > cd terraform/staging/rds
  > terraform init
  > terraform refresh
  > terraform state pull
  > terraform state show module.rds.aws_db_instance.master # Should display current state
  > terraform state rm module.rds.aws_db_instance.master
  ```
- [ ] Update the file `terraform/staging/rds/common.tf`. For example, if your new database has the name `my-new-instance-staging`, you should use the value `my-new-instance` as the name:

  ```diff
  variable "name" {
  -    default = "events-meepo"
  +    default = "my-new-instance"
  }
  ```
- [ ] Update your new database to match configurations in Terraform:

  ```bash
  > terraform import module.rds.aws_db_instance.master my-new-instance-staging
  > terraform plan
  > terraform apply # Should only has update in-place changes
  ```
- [ ] Wait for `terraform apply` to finish, and verify that your new database status is `Available` on AWS console
- [ ] Navigate to your new database on the AWS console, and select `Modify`:
  - [ ] Change `New master passord` to be the same as the original instance. Value can be found in 1Password
  - [ ] Select `Continue`, `Apply immediately`, and `Modify DB Instance`
  - [ ] From your database instance page on the AWS console, select `Reboot` from the top-right menu dropdown 
  - [ ] Wait for your new database status to change to `Available` on AWS console
- [ ] Copy your new database instance's **`Endpoint`**
- [ ] Run the following query to end all live squads from your terminal:
  - [ ] Connect to the newly created database. Replace `<Endpoint>` in the command with the copied text:

    ```bash
    > psql -h <Endpoint> -p 5432 -U master meepo
    ```   
  - [ ] Password is identical to the original instance, and can be found in 1Password
  - [ ] Run the following query:

    ```postgres
    meepo=> update squads set status = 'ended' where status = 'live';
    meepo=> update squad_members set status = 'deleted', deleted_at = current_timestamp where status <> 'active';
    meepo=> update squad_invitations set status = 'deleted' where status = 'pending' or status = 'rejected';
    ```
  - [ ] Confirm that there are no remaining live squads:

    ```postgres
    meepo=> select * from squads where status = 'live';
    meepo=> select * from squad_members where status = 'active';
    meepo=> select * from squad_invitations where status = 'pending' or status = 'rejected';
    ```
  - [ ] Type `\q` to quit
- [ ] Navigate to Clean-Deploy to redeploy Meepo, [`staging`](https://deploy.xarth.tv/#/twitch-events/meepo/history?env=staging) or [`production`](https://deploy.xarth.tv/#/twitch-events/meepo/history?env=production)
  - [ ] Click `Redeploy` on the latest commit
- [ ] Wait for the deploy to complete
- [ ] Verify that all everything is okay, by running a Jenkins build (which will run tests)
  - [ ] Navigate to [Jenkins](https://jenkins-og.xarth.tv/job/events-meepo-build/) and select `Build Now`
  - [ ] Make sure the build passes

## Contact Us

  * [Jira Board](https://jira.twitch.com/secure/RapidBoard.jspa?rapidView=342&projectKey=CPLAT)
  * Slack channel: [#cplat-backend-deploys](https://twitch.slack.com/messages/cplat-backend-deploys) OR [#dashboard-feedback](https://twitch.slack.com/messages/dashboard-feedback)

## Service Links

  * AWS Accounts
    * Production (twitch-feed-aws): [Console](https://twitch-feed-aws.signin.aws.amazon.com/console)
    * Staging (twitch-feed-dev): [Console](https://twitch-feed-dev.signin.aws.amazon.com/console)
  * [Deploy (Clean-Deploy)](https://deploy.xarth.tv/#/twitch-events/meepo)
  * Errors (Rollbar)
    * [Production](https://rollbar.com/Twitch/Meepo/?environment=production)
    * [Staging](https://rollbar.com/Twitch/Meepo/?environment=staging)
  * Secret Management
    * [1Password](https://twitch.1password.com/vaults/ii36drn5bbzogxrgtmr756eaky/) (for shared passwords that developers use for debugging)
    * [Sandstorm](https://dashboard.xarth.tv/sandstorm/manage-secrets?nameFilter=meepo) (for passwords meepo uses)
  * Service Endpoint
    * Production: http://production.meepo.twitch.a2z.com
    * Staging: http://staging.meepo.twitch.a2z.com
  * PrivateLink
    * Production: com.amazonaws.vpce.us-west-2.vpce-svc-0a000d750036b5c16
    * Staging: com.amazonaws.vpce.us-west-2.vpce-svc-0702fe6d2df3c7d79
  * [Stats (Grafana)](https://grafana.xarth.tv/d/MUrsdCdmk/meepo?orgId=1)
  
