CREATE TYPE squad_status AS ENUM ('pending', 'live', 'ended');
CREATE TYPE squad_invitation_status AS ENUM ('pending', 'accepted', 'rejected', 'expired', 'deleted');

CREATE TABLE IF NOT EXISTS squads (
  id          varchar(64)   PRIMARY KEY,
  owner_id    varchar(20),
  status      squad_status  NOT NULL,
  created_by  varchar(20)   NOT NULL,

  created_at  timestamp     DEFAULT current_timestamp NOT NULL,
  updated_at  timestamp     NOT NULL
);

CREATE TABLE IF NOT EXISTS squad_members (
  id          varchar(64)   PRIMARY KEY,
  squad_id    varchar(64)   NOT NULL, 
  member_id   varchar(20)   NOT NULL, 

  created_at  timestamp     DEFAULT current_timestamp NOT NULL, 
  deleted_at  timestamp     DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS squad_invitations (
  id            varchar(64)               PRIMARY KEY,
  squad_id      varchar(64)               NOT NULL, 
  sender_id     varchar(20)               NOT NULL, 
  recipient_id  varchar(20)               NOT NULL,
  status        squad_invitation_status   NOT NULL,

  created_at    timestamp                 DEFAULT current_timestamp NOT NULL, 
  updated_at    timestamp                 NOT NULL
);

CREATE INDEX squads_owner_id_idx ON squads (owner_id);
CREATE INDEX squad_members_squad_id_idx ON squad_members (squad_id);
CREATE INDEX squad_members_member_id_idx ON squad_members (member_id);
CREATE INDEX squad_members_deleted_at_idx ON squad_members (deleted_at);
CREATE INDEX squad_invitations_squad_id_idx ON squad_invitations (squad_id);
CREATE INDEX squad_invitations_recipient_id_idx ON squad_invitations (recipient_id);
CREATE INDEX squad_invitations_status_idx ON squad_invitations (status);
CREATE INDEX squad_invitations_created_at_idx ON squad_invitations (created_at);
CREATE INDEX squad_invitations_status_created_at_idx ON squad_invitations (status, created_at);
