package clients

import (
	spadeclient "code.justin.tv/common/spade-client-go/spade"
	"code.justin.tv/feeds/errors"
	"golang.org/x/net/context"
)

// Spade is an interface based on common's spadeclient
type Spade interface {
	TrackEvent(ctx context.Context, event string, properties interface{}) error
}

// SpadeClient used within meepo
type SpadeClient interface {
	TrackEvent(ctx context.Context, event string, properties interface{}) error
}

type spadeImpl struct {
	baseClient Spade
}

// NewSpadeClient creates a new client for use within meepo
func NewSpadeClient() (SpadeClient, error) {
	spadeClient, err := spadeclient.NewClient()
	if err != nil {
		return nil, errors.New("failed to start spade client")
	}

	return &spadeImpl{baseClient: spadeClient}, nil
}

func (s *spadeImpl) TrackEvent(ctx context.Context, event string, properties interface{}) error {
	return s.baseClient.TrackEvent(ctx, event, properties)
}
