// Code generated by protoc-gen-twirp v8.0.0, DO NOT EDIT.
// source: meepo/rpc/meepo.proto

/*
Package meepo is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v8.0.0.

It is generated from these files:
	meepo/rpc/meepo.proto
	meepo/rpc/models.proto
*/
package meepo

import context "context"
import fmt "fmt"
import http "net/http"
import ioutil "io/ioutil"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import bytes "bytes"
import io "io"
import path "path"
import url "net/url"

// This is a compile-time assertion to ensure that this generated file
// is compatible with the twirp package used in your project.
// A compilation error at this line likely means your copy of the
// twirp package needs to be updated.
const _ = twirp.TwirpPackageIsVersion7

// ===============
// Meepo Interface
// ===============

// Meepo supports squad streaming on Twitch.
type Meepo interface {
	// GetSquadByChannelID returns the squad the given channel belongs to, if
	// they belong to one.
	GetSquadByChannelID(context.Context, *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error)

	// GetSquadByID returns the squad with the given ID.
	GetSquadByID(context.Context, *GetSquadByIDRequest) (*GetSquadByIDResponse, error)

	// CreateMembership sets a user as a member of a squad.
	CreateMembership(context.Context, *CreateMembershipRequest) (*CreateMembershipResponse, error)

	// UpdateSquad updates the squad with the given information and returns the
	// squad.
	UpdateSquad(context.Context, *UpdateSquadRequest) (*UpdateSquadResponse, error)

	// LeaveSquad deletes the user from the squad they are in, and updates the
	// owner and status of the squad if necessary.
	LeaveSquad(context.Context, *LeaveSquadRequest) (*LeaveSquadResponse, error)

	// RemoveMember removes a user from a squad, and updates the owner and
	// status of the squad if necessary.
	RemoveMember(context.Context, *RemoveMemberRequest) (*RemoveMemberResponse, error)

	// CreateInvitation creates an invitation from the sender to the recipient,
	// creating the squad if necessary.
	CreateInvitation(context.Context, *CreateInvitationRequest) (*CreateInvitationResponse, error)

	// GetIncomingInvitationsByChannelID returns a list of pending invitations
	// to the channel.
	GetIncomingInvitationsByChannelID(context.Context, *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error)

	// CreateSquad creates a pending squad with the given channel as the owner.
	CreateSquad(context.Context, *CreateSquadRequest) (*CreateSquadResponse, error)

	// GetInvitationsBySquadID returns a list of invitations to the squad with
	// the given ID and status.
	GetInvitationsBySquadID(context.Context, *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error)

	// AcceptInvitation accepts an invitation and makes the recipient of the
	// invitation a member of the squad.
	AcceptInvitation(context.Context, *AcceptInvitationRequest) (*AcceptInvitationResponse, error)

	// DeleteInvitation updates invitation status to deleted and
	// returns the deleted invitation.
	DeleteInvitation(context.Context, *DeleteInvitationRequest) (*DeleteInvitationResponse, error)

	// AuthorizeTopicSubscription determines whether the caller
	// is authorized to subscribe to a PubSub topic.
	AuthorizeTopicSubscription(context.Context, *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error)

	// RejectInvitation updates invitation status to rejected,
	// and ensures that a max number of rejected invitations is respected.
	// Returns the rejected invitation.
	RejectInvitation(context.Context, *RejectInvitationRequest) (*RejectInvitationResponse, error)

	// GetIncomingInvitationsCountByChannelID gets the number of incoming,
	// pending invitations for a channel.
	GetIncomingInvitationsCountByChannelID(context.Context, *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error)

	// SetPrimaryPlayer sets the primary player channel ID for a device & squad
	// pair.
	SetPrimaryPlayer(context.Context, *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error)

	// ShouldShowAd determines whether the ad should be declined.
	ShouldShowAd(context.Context, *ShouldShowAdRequest) (*ShouldShowAdResponse, error)

	// RejectOutOfNetworkInvitations updates a user's out-of-network invitations
	// to rejected, and ensures that a max number of rejected invitations is
	// respected.
	RejectOutOfNetworkInvitations(context.Context, *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error)

	// CanAccessSquads determines whether a user can access squad management
	// features such as inviting members to a squad and viewing the squad
	// stream dashboard widget.
	CanAccessSquads(context.Context, *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error)

	// GetInvitePolicyByChannelID fetches the invite policy corresponding
	// to a given ChannelID, showing who can send them invites.
	GetInvitePolicyByChannelID(context.Context, *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error)

	// UpdateInvitePolicyByChannelID updates the invite policy corresponding
	// to a given ChannelID. The updated invite policy is included
	// in the response.
	UpdateInvitePolicyByChannelID(context.Context, *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error)
}

// =====================
// Meepo Protobuf Client
// =====================

type meepoProtobufClient struct {
	client      HTTPClient
	urls        [21]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewMeepoProtobufClient creates a Protobuf client that implements the Meepo interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewMeepoProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Meepo {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(clientOpts.PathPrefix(), "meepo.v1", "Meepo")
	urls := [21]string{
		serviceURL + "GetSquadByChannelID",
		serviceURL + "GetSquadByID",
		serviceURL + "CreateMembership",
		serviceURL + "UpdateSquad",
		serviceURL + "LeaveSquad",
		serviceURL + "RemoveMember",
		serviceURL + "CreateInvitation",
		serviceURL + "GetIncomingInvitationsByChannelID",
		serviceURL + "CreateSquad",
		serviceURL + "GetInvitationsBySquadID",
		serviceURL + "AcceptInvitation",
		serviceURL + "DeleteInvitation",
		serviceURL + "AuthorizeTopicSubscription",
		serviceURL + "RejectInvitation",
		serviceURL + "GetIncomingInvitationsCountByChannelID",
		serviceURL + "SetPrimaryPlayer",
		serviceURL + "ShouldShowAd",
		serviceURL + "RejectOutOfNetworkInvitations",
		serviceURL + "CanAccessSquads",
		serviceURL + "GetInvitePolicyByChannelID",
		serviceURL + "UpdateInvitePolicyByChannelID",
	}

	return &meepoProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *meepoProtobufClient) GetSquadByChannelID(ctx context.Context, in *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	caller := c.callGetSquadByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByChannelIDRequest) when calling interceptor")
					}
					return c.callGetSquadByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callGetSquadByChannelID(ctx context.Context, in *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
	out := new(GetSquadByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) GetSquadByID(ctx context.Context, in *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	caller := c.callGetSquadByID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByIDRequest) when calling interceptor")
					}
					return c.callGetSquadByID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callGetSquadByID(ctx context.Context, in *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
	out := new(GetSquadByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) CreateMembership(ctx context.Context, in *CreateMembershipRequest) (*CreateMembershipResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	caller := c.callCreateMembership
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateMembershipRequest) (*CreateMembershipResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateMembershipRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateMembershipRequest) when calling interceptor")
					}
					return c.callCreateMembership(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateMembershipResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateMembershipResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callCreateMembership(ctx context.Context, in *CreateMembershipRequest) (*CreateMembershipResponse, error) {
	out := new(CreateMembershipResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) UpdateSquad(ctx context.Context, in *UpdateSquadRequest) (*UpdateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	caller := c.callUpdateSquad
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateSquadRequest) (*UpdateSquadResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSquadRequest) when calling interceptor")
					}
					return c.callUpdateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callUpdateSquad(ctx context.Context, in *UpdateSquadRequest) (*UpdateSquadResponse, error) {
	out := new(UpdateSquadResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) LeaveSquad(ctx context.Context, in *LeaveSquadRequest) (*LeaveSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	caller := c.callLeaveSquad
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *LeaveSquadRequest) (*LeaveSquadResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LeaveSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LeaveSquadRequest) when calling interceptor")
					}
					return c.callLeaveSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LeaveSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LeaveSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callLeaveSquad(ctx context.Context, in *LeaveSquadRequest) (*LeaveSquadResponse, error) {
	out := new(LeaveSquadResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) RemoveMember(ctx context.Context, in *RemoveMemberRequest) (*RemoveMemberResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	caller := c.callRemoveMember
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RemoveMemberRequest) (*RemoveMemberResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveMemberRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveMemberRequest) when calling interceptor")
					}
					return c.callRemoveMember(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RemoveMemberResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RemoveMemberResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callRemoveMember(ctx context.Context, in *RemoveMemberRequest) (*RemoveMemberResponse, error) {
	out := new(RemoveMemberResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) CreateInvitation(ctx context.Context, in *CreateInvitationRequest) (*CreateInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	caller := c.callCreateInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateInvitationRequest) (*CreateInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateInvitationRequest) when calling interceptor")
					}
					return c.callCreateInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callCreateInvitation(ctx context.Context, in *CreateInvitationRequest) (*CreateInvitationResponse, error) {
	out := new(CreateInvitationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) GetIncomingInvitationsByChannelID(ctx context.Context, in *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	caller := c.callGetIncomingInvitationsByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsByChannelIDRequest) when calling interceptor")
					}
					return c.callGetIncomingInvitationsByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callGetIncomingInvitationsByChannelID(ctx context.Context, in *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
	out := new(GetIncomingInvitationsByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) CreateSquad(ctx context.Context, in *CreateSquadRequest) (*CreateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	caller := c.callCreateSquad
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSquadRequest) (*CreateSquadResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSquadRequest) when calling interceptor")
					}
					return c.callCreateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callCreateSquad(ctx context.Context, in *CreateSquadRequest) (*CreateSquadResponse, error) {
	out := new(CreateSquadResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) GetInvitationsBySquadID(ctx context.Context, in *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	caller := c.callGetInvitationsBySquadID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitationsBySquadIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitationsBySquadIDRequest) when calling interceptor")
					}
					return c.callGetInvitationsBySquadID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitationsBySquadIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitationsBySquadIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callGetInvitationsBySquadID(ctx context.Context, in *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
	out := new(GetInvitationsBySquadIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) AcceptInvitation(ctx context.Context, in *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	caller := c.callAcceptInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AcceptInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AcceptInvitationRequest) when calling interceptor")
					}
					return c.callAcceptInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AcceptInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AcceptInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callAcceptInvitation(ctx context.Context, in *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
	out := new(AcceptInvitationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) DeleteInvitation(ctx context.Context, in *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	caller := c.callDeleteInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteInvitationRequest) when calling interceptor")
					}
					return c.callDeleteInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callDeleteInvitation(ctx context.Context, in *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
	out := new(DeleteInvitationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) AuthorizeTopicSubscription(ctx context.Context, in *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	caller := c.callAuthorizeTopicSubscription
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AuthorizeTopicSubscriptionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AuthorizeTopicSubscriptionRequest) when calling interceptor")
					}
					return c.callAuthorizeTopicSubscription(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AuthorizeTopicSubscriptionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AuthorizeTopicSubscriptionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callAuthorizeTopicSubscription(ctx context.Context, in *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
	out := new(AuthorizeTopicSubscriptionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) RejectInvitation(ctx context.Context, in *RejectInvitationRequest) (*RejectInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	caller := c.callRejectInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RejectInvitationRequest) (*RejectInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectInvitationRequest) when calling interceptor")
					}
					return c.callRejectInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callRejectInvitation(ctx context.Context, in *RejectInvitationRequest) (*RejectInvitationResponse, error) {
	out := new(RejectInvitationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) GetIncomingInvitationsCountByChannelID(ctx context.Context, in *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	caller := c.callGetIncomingInvitationsCountByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsCountByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsCountByChannelIDRequest) when calling interceptor")
					}
					return c.callGetIncomingInvitationsCountByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsCountByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsCountByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callGetIncomingInvitationsCountByChannelID(ctx context.Context, in *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
	out := new(GetIncomingInvitationsCountByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) SetPrimaryPlayer(ctx context.Context, in *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	caller := c.callSetPrimaryPlayer
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SetPrimaryPlayerRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SetPrimaryPlayerRequest) when calling interceptor")
					}
					return c.callSetPrimaryPlayer(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SetPrimaryPlayerResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SetPrimaryPlayerResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callSetPrimaryPlayer(ctx context.Context, in *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
	out := new(SetPrimaryPlayerResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) ShouldShowAd(ctx context.Context, in *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	caller := c.callShouldShowAd
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ShouldShowAdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ShouldShowAdRequest) when calling interceptor")
					}
					return c.callShouldShowAd(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ShouldShowAdResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ShouldShowAdResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callShouldShowAd(ctx context.Context, in *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
	out := new(ShouldShowAdResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) RejectOutOfNetworkInvitations(ctx context.Context, in *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	caller := c.callRejectOutOfNetworkInvitations
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectOutOfNetworkInvitationsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectOutOfNetworkInvitationsRequest) when calling interceptor")
					}
					return c.callRejectOutOfNetworkInvitations(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectOutOfNetworkInvitationsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectOutOfNetworkInvitationsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callRejectOutOfNetworkInvitations(ctx context.Context, in *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
	out := new(RejectOutOfNetworkInvitationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) CanAccessSquads(ctx context.Context, in *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	caller := c.callCanAccessSquads
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CanAccessSquadsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CanAccessSquadsRequest) when calling interceptor")
					}
					return c.callCanAccessSquads(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CanAccessSquadsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CanAccessSquadsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callCanAccessSquads(ctx context.Context, in *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
	out := new(CanAccessSquadsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) GetInvitePolicyByChannelID(ctx context.Context, in *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	caller := c.callGetInvitePolicyByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return c.callGetInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callGetInvitePolicyByChannelID(ctx context.Context, in *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
	out := new(GetInvitePolicyByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoProtobufClient) UpdateInvitePolicyByChannelID(ctx context.Context, in *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	caller := c.callUpdateInvitePolicyByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return c.callUpdateInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoProtobufClient) callUpdateInvitePolicyByChannelID(ctx context.Context, in *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
	out := new(UpdateInvitePolicyByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================
// Meepo JSON Client
// =================

type meepoJSONClient struct {
	client      HTTPClient
	urls        [21]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewMeepoJSONClient creates a JSON client that implements the Meepo interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewMeepoJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Meepo {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(clientOpts.PathPrefix(), "meepo.v1", "Meepo")
	urls := [21]string{
		serviceURL + "GetSquadByChannelID",
		serviceURL + "GetSquadByID",
		serviceURL + "CreateMembership",
		serviceURL + "UpdateSquad",
		serviceURL + "LeaveSquad",
		serviceURL + "RemoveMember",
		serviceURL + "CreateInvitation",
		serviceURL + "GetIncomingInvitationsByChannelID",
		serviceURL + "CreateSquad",
		serviceURL + "GetInvitationsBySquadID",
		serviceURL + "AcceptInvitation",
		serviceURL + "DeleteInvitation",
		serviceURL + "AuthorizeTopicSubscription",
		serviceURL + "RejectInvitation",
		serviceURL + "GetIncomingInvitationsCountByChannelID",
		serviceURL + "SetPrimaryPlayer",
		serviceURL + "ShouldShowAd",
		serviceURL + "RejectOutOfNetworkInvitations",
		serviceURL + "CanAccessSquads",
		serviceURL + "GetInvitePolicyByChannelID",
		serviceURL + "UpdateInvitePolicyByChannelID",
	}

	return &meepoJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *meepoJSONClient) GetSquadByChannelID(ctx context.Context, in *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	caller := c.callGetSquadByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByChannelIDRequest) when calling interceptor")
					}
					return c.callGetSquadByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callGetSquadByChannelID(ctx context.Context, in *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
	out := new(GetSquadByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) GetSquadByID(ctx context.Context, in *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	caller := c.callGetSquadByID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByIDRequest) when calling interceptor")
					}
					return c.callGetSquadByID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callGetSquadByID(ctx context.Context, in *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
	out := new(GetSquadByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) CreateMembership(ctx context.Context, in *CreateMembershipRequest) (*CreateMembershipResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	caller := c.callCreateMembership
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateMembershipRequest) (*CreateMembershipResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateMembershipRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateMembershipRequest) when calling interceptor")
					}
					return c.callCreateMembership(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateMembershipResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateMembershipResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callCreateMembership(ctx context.Context, in *CreateMembershipRequest) (*CreateMembershipResponse, error) {
	out := new(CreateMembershipResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) UpdateSquad(ctx context.Context, in *UpdateSquadRequest) (*UpdateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	caller := c.callUpdateSquad
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateSquadRequest) (*UpdateSquadResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSquadRequest) when calling interceptor")
					}
					return c.callUpdateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callUpdateSquad(ctx context.Context, in *UpdateSquadRequest) (*UpdateSquadResponse, error) {
	out := new(UpdateSquadResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) LeaveSquad(ctx context.Context, in *LeaveSquadRequest) (*LeaveSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	caller := c.callLeaveSquad
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *LeaveSquadRequest) (*LeaveSquadResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LeaveSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LeaveSquadRequest) when calling interceptor")
					}
					return c.callLeaveSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LeaveSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LeaveSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callLeaveSquad(ctx context.Context, in *LeaveSquadRequest) (*LeaveSquadResponse, error) {
	out := new(LeaveSquadResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) RemoveMember(ctx context.Context, in *RemoveMemberRequest) (*RemoveMemberResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	caller := c.callRemoveMember
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RemoveMemberRequest) (*RemoveMemberResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveMemberRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveMemberRequest) when calling interceptor")
					}
					return c.callRemoveMember(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RemoveMemberResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RemoveMemberResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callRemoveMember(ctx context.Context, in *RemoveMemberRequest) (*RemoveMemberResponse, error) {
	out := new(RemoveMemberResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) CreateInvitation(ctx context.Context, in *CreateInvitationRequest) (*CreateInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	caller := c.callCreateInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateInvitationRequest) (*CreateInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateInvitationRequest) when calling interceptor")
					}
					return c.callCreateInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callCreateInvitation(ctx context.Context, in *CreateInvitationRequest) (*CreateInvitationResponse, error) {
	out := new(CreateInvitationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) GetIncomingInvitationsByChannelID(ctx context.Context, in *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	caller := c.callGetIncomingInvitationsByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsByChannelIDRequest) when calling interceptor")
					}
					return c.callGetIncomingInvitationsByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callGetIncomingInvitationsByChannelID(ctx context.Context, in *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
	out := new(GetIncomingInvitationsByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) CreateSquad(ctx context.Context, in *CreateSquadRequest) (*CreateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	caller := c.callCreateSquad
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSquadRequest) (*CreateSquadResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSquadRequest) when calling interceptor")
					}
					return c.callCreateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callCreateSquad(ctx context.Context, in *CreateSquadRequest) (*CreateSquadResponse, error) {
	out := new(CreateSquadResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) GetInvitationsBySquadID(ctx context.Context, in *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	caller := c.callGetInvitationsBySquadID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitationsBySquadIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitationsBySquadIDRequest) when calling interceptor")
					}
					return c.callGetInvitationsBySquadID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitationsBySquadIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitationsBySquadIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callGetInvitationsBySquadID(ctx context.Context, in *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
	out := new(GetInvitationsBySquadIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) AcceptInvitation(ctx context.Context, in *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	caller := c.callAcceptInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AcceptInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AcceptInvitationRequest) when calling interceptor")
					}
					return c.callAcceptInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AcceptInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AcceptInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callAcceptInvitation(ctx context.Context, in *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
	out := new(AcceptInvitationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) DeleteInvitation(ctx context.Context, in *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	caller := c.callDeleteInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteInvitationRequest) when calling interceptor")
					}
					return c.callDeleteInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callDeleteInvitation(ctx context.Context, in *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
	out := new(DeleteInvitationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) AuthorizeTopicSubscription(ctx context.Context, in *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	caller := c.callAuthorizeTopicSubscription
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AuthorizeTopicSubscriptionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AuthorizeTopicSubscriptionRequest) when calling interceptor")
					}
					return c.callAuthorizeTopicSubscription(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AuthorizeTopicSubscriptionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AuthorizeTopicSubscriptionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callAuthorizeTopicSubscription(ctx context.Context, in *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
	out := new(AuthorizeTopicSubscriptionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) RejectInvitation(ctx context.Context, in *RejectInvitationRequest) (*RejectInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	caller := c.callRejectInvitation
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RejectInvitationRequest) (*RejectInvitationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectInvitationRequest) when calling interceptor")
					}
					return c.callRejectInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callRejectInvitation(ctx context.Context, in *RejectInvitationRequest) (*RejectInvitationResponse, error) {
	out := new(RejectInvitationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) GetIncomingInvitationsCountByChannelID(ctx context.Context, in *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	caller := c.callGetIncomingInvitationsCountByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsCountByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsCountByChannelIDRequest) when calling interceptor")
					}
					return c.callGetIncomingInvitationsCountByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsCountByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsCountByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callGetIncomingInvitationsCountByChannelID(ctx context.Context, in *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
	out := new(GetIncomingInvitationsCountByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) SetPrimaryPlayer(ctx context.Context, in *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	caller := c.callSetPrimaryPlayer
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SetPrimaryPlayerRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SetPrimaryPlayerRequest) when calling interceptor")
					}
					return c.callSetPrimaryPlayer(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SetPrimaryPlayerResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SetPrimaryPlayerResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callSetPrimaryPlayer(ctx context.Context, in *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
	out := new(SetPrimaryPlayerResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) ShouldShowAd(ctx context.Context, in *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	caller := c.callShouldShowAd
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ShouldShowAdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ShouldShowAdRequest) when calling interceptor")
					}
					return c.callShouldShowAd(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ShouldShowAdResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ShouldShowAdResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callShouldShowAd(ctx context.Context, in *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
	out := new(ShouldShowAdResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) RejectOutOfNetworkInvitations(ctx context.Context, in *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	caller := c.callRejectOutOfNetworkInvitations
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectOutOfNetworkInvitationsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectOutOfNetworkInvitationsRequest) when calling interceptor")
					}
					return c.callRejectOutOfNetworkInvitations(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectOutOfNetworkInvitationsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectOutOfNetworkInvitationsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callRejectOutOfNetworkInvitations(ctx context.Context, in *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
	out := new(RejectOutOfNetworkInvitationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) CanAccessSquads(ctx context.Context, in *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	caller := c.callCanAccessSquads
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CanAccessSquadsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CanAccessSquadsRequest) when calling interceptor")
					}
					return c.callCanAccessSquads(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CanAccessSquadsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CanAccessSquadsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callCanAccessSquads(ctx context.Context, in *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
	out := new(CanAccessSquadsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) GetInvitePolicyByChannelID(ctx context.Context, in *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	caller := c.callGetInvitePolicyByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return c.callGetInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callGetInvitePolicyByChannelID(ctx context.Context, in *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
	out := new(GetInvitePolicyByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *meepoJSONClient) UpdateInvitePolicyByChannelID(ctx context.Context, in *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	caller := c.callUpdateInvitePolicyByChannelID
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return c.callUpdateInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *meepoJSONClient) callUpdateInvitePolicyByChannelID(ctx context.Context, in *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
	out := new(UpdateInvitePolicyByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================
// Meepo Server Handler
// ====================

type meepoServer struct {
	Meepo
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
}

// NewMeepoServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewMeepoServer(svc Meepo, opts ...interface{}) TwirpServer {
	serverOpts := twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(&serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(&serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T on NewMeepoServer", o))
		}
	}

	return &meepoServer{
		Meepo:            svc,
		pathPrefix:       serverOpts.PathPrefix(),
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		hooks:            serverOpts.Hooks,
		jsonSkipDefaults: serverOpts.JSONSkipDefaults,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *meepoServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *meepoServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// MeepoPathPrefix is a convenience constant that could used to identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// that add a "/twirp" prefix by default, and use CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const MeepoPathPrefix = "/twirp/meepo.v1.Meepo/"

func (s *meepoServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "meepo.v1.Meepo" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "GetSquadByChannelID":
		s.serveGetSquadByChannelID(ctx, resp, req)
		return
	case "GetSquadByID":
		s.serveGetSquadByID(ctx, resp, req)
		return
	case "CreateMembership":
		s.serveCreateMembership(ctx, resp, req)
		return
	case "UpdateSquad":
		s.serveUpdateSquad(ctx, resp, req)
		return
	case "LeaveSquad":
		s.serveLeaveSquad(ctx, resp, req)
		return
	case "RemoveMember":
		s.serveRemoveMember(ctx, resp, req)
		return
	case "CreateInvitation":
		s.serveCreateInvitation(ctx, resp, req)
		return
	case "GetIncomingInvitationsByChannelID":
		s.serveGetIncomingInvitationsByChannelID(ctx, resp, req)
		return
	case "CreateSquad":
		s.serveCreateSquad(ctx, resp, req)
		return
	case "GetInvitationsBySquadID":
		s.serveGetInvitationsBySquadID(ctx, resp, req)
		return
	case "AcceptInvitation":
		s.serveAcceptInvitation(ctx, resp, req)
		return
	case "DeleteInvitation":
		s.serveDeleteInvitation(ctx, resp, req)
		return
	case "AuthorizeTopicSubscription":
		s.serveAuthorizeTopicSubscription(ctx, resp, req)
		return
	case "RejectInvitation":
		s.serveRejectInvitation(ctx, resp, req)
		return
	case "GetIncomingInvitationsCountByChannelID":
		s.serveGetIncomingInvitationsCountByChannelID(ctx, resp, req)
		return
	case "SetPrimaryPlayer":
		s.serveSetPrimaryPlayer(ctx, resp, req)
		return
	case "ShouldShowAd":
		s.serveShouldShowAd(ctx, resp, req)
		return
	case "RejectOutOfNetworkInvitations":
		s.serveRejectOutOfNetworkInvitations(ctx, resp, req)
		return
	case "CanAccessSquads":
		s.serveCanAccessSquads(ctx, resp, req)
		return
	case "GetInvitePolicyByChannelID":
		s.serveGetInvitePolicyByChannelID(ctx, resp, req)
		return
	case "UpdateInvitePolicyByChannelID":
		s.serveUpdateInvitePolicyByChannelID(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *meepoServer) serveGetSquadByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSquadByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSquadByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetSquadByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetSquadByChannelIDRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.GetSquadByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetSquadByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSquadByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByChannelIDResponse and nil error while calling GetSquadByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetSquadByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetSquadByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.GetSquadByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetSquadByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSquadByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByChannelIDResponse and nil error while calling GetSquadByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetSquadByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSquadByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSquadByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetSquadByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetSquadByIDRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.GetSquadByID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByIDRequest) when calling interceptor")
					}
					return s.Meepo.GetSquadByID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSquadByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByIDResponse and nil error while calling GetSquadByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetSquadByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetSquadByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.GetSquadByID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSquadByIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSquadByIDRequest) when calling interceptor")
					}
					return s.Meepo.GetSquadByID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSquadByIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSquadByIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSquadByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByIDResponse and nil error while calling GetSquadByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateMembership(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateMembershipJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateMembershipProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCreateMembershipJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateMembershipRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.CreateMembership
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateMembershipRequest) (*CreateMembershipResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateMembershipRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateMembershipRequest) when calling interceptor")
					}
					return s.Meepo.CreateMembership(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateMembershipResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateMembershipResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CreateMembershipResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateMembershipResponse and nil error while calling CreateMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateMembershipProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateMembershipRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.CreateMembership
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateMembershipRequest) (*CreateMembershipResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateMembershipRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateMembershipRequest) when calling interceptor")
					}
					return s.Meepo.CreateMembership(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateMembershipResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateMembershipResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CreateMembershipResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateMembershipResponse and nil error while calling CreateMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateSquad(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateSquadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSquadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveUpdateSquadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpdateSquadRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.UpdateSquad
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateSquadRequest) (*UpdateSquadResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSquadRequest) when calling interceptor")
					}
					return s.Meepo.UpdateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpdateSquadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSquadResponse and nil error while calling UpdateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateSquadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpdateSquadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.UpdateSquad
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateSquadRequest) (*UpdateSquadResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSquadRequest) when calling interceptor")
					}
					return s.Meepo.UpdateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpdateSquadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSquadResponse and nil error while calling UpdateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveLeaveSquad(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLeaveSquadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLeaveSquadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveLeaveSquadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(LeaveSquadRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.LeaveSquad
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *LeaveSquadRequest) (*LeaveSquadResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LeaveSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LeaveSquadRequest) when calling interceptor")
					}
					return s.Meepo.LeaveSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LeaveSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LeaveSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *LeaveSquadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveSquadResponse and nil error while calling LeaveSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveLeaveSquadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(LeaveSquadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.LeaveSquad
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *LeaveSquadRequest) (*LeaveSquadResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LeaveSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LeaveSquadRequest) when calling interceptor")
					}
					return s.Meepo.LeaveSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LeaveSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LeaveSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *LeaveSquadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveSquadResponse and nil error while calling LeaveSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRemoveMember(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveMemberJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveMemberProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveRemoveMemberJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(RemoveMemberRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.RemoveMember
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RemoveMemberRequest) (*RemoveMemberResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveMemberRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveMemberRequest) when calling interceptor")
					}
					return s.Meepo.RemoveMember(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RemoveMemberResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RemoveMemberResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *RemoveMemberResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveMemberResponse and nil error while calling RemoveMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRemoveMemberProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(RemoveMemberRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.RemoveMember
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RemoveMemberRequest) (*RemoveMemberResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveMemberRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveMemberRequest) when calling interceptor")
					}
					return s.Meepo.RemoveMember(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RemoveMemberResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RemoveMemberResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *RemoveMemberResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveMemberResponse and nil error while calling RemoveMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCreateInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateInvitationRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.CreateInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateInvitationRequest) (*CreateInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateInvitationRequest) when calling interceptor")
					}
					return s.Meepo.CreateInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CreateInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateInvitationResponse and nil error while calling CreateInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.CreateInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateInvitationRequest) (*CreateInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateInvitationRequest) when calling interceptor")
					}
					return s.Meepo.CreateInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CreateInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateInvitationResponse and nil error while calling CreateInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetIncomingInvitationsByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetIncomingInvitationsByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetIncomingInvitationsByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetIncomingInvitationsByChannelIDRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.GetIncomingInvitationsByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetIncomingInvitationsByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetIncomingInvitationsByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsByChannelIDResponse and nil error while calling GetIncomingInvitationsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetIncomingInvitationsByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.GetIncomingInvitationsByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetIncomingInvitationsByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetIncomingInvitationsByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsByChannelIDResponse and nil error while calling GetIncomingInvitationsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateSquad(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateSquadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSquadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCreateSquadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateSquadRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.CreateSquad
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSquadRequest) (*CreateSquadResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSquadRequest) when calling interceptor")
					}
					return s.Meepo.CreateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CreateSquadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSquadResponse and nil error while calling CreateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateSquadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateSquadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.CreateSquad
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSquadRequest) (*CreateSquadResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSquadRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSquadRequest) when calling interceptor")
					}
					return s.Meepo.CreateSquad(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CreateSquadResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CreateSquadResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CreateSquadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSquadResponse and nil error while calling CreateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitationsBySquadID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetInvitationsBySquadIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetInvitationsBySquadIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetInvitationsBySquadIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetInvitationsBySquadIDRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.GetInvitationsBySquadID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitationsBySquadIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitationsBySquadIDRequest) when calling interceptor")
					}
					return s.Meepo.GetInvitationsBySquadID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitationsBySquadIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitationsBySquadIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetInvitationsBySquadIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitationsBySquadIDResponse and nil error while calling GetInvitationsBySquadID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitationsBySquadIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetInvitationsBySquadIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.GetInvitationsBySquadID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitationsBySquadIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitationsBySquadIDRequest) when calling interceptor")
					}
					return s.Meepo.GetInvitationsBySquadID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitationsBySquadIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitationsBySquadIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetInvitationsBySquadIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitationsBySquadIDResponse and nil error while calling GetInvitationsBySquadID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAcceptInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAcceptInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAcceptInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveAcceptInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(AcceptInvitationRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.AcceptInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AcceptInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AcceptInvitationRequest) when calling interceptor")
					}
					return s.Meepo.AcceptInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AcceptInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AcceptInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *AcceptInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcceptInvitationResponse and nil error while calling AcceptInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAcceptInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(AcceptInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.AcceptInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AcceptInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AcceptInvitationRequest) when calling interceptor")
					}
					return s.Meepo.AcceptInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AcceptInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AcceptInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *AcceptInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcceptInvitationResponse and nil error while calling AcceptInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveDeleteInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveDeleteInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(DeleteInvitationRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.DeleteInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteInvitationRequest) when calling interceptor")
					}
					return s.Meepo.DeleteInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteInvitationResponse and nil error while calling DeleteInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveDeleteInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(DeleteInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.DeleteInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteInvitationRequest) when calling interceptor")
					}
					return s.Meepo.DeleteInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteInvitationResponse and nil error while calling DeleteInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAuthorizeTopicSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAuthorizeTopicSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAuthorizeTopicSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveAuthorizeTopicSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(AuthorizeTopicSubscriptionRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.AuthorizeTopicSubscription
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AuthorizeTopicSubscriptionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AuthorizeTopicSubscriptionRequest) when calling interceptor")
					}
					return s.Meepo.AuthorizeTopicSubscription(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AuthorizeTopicSubscriptionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AuthorizeTopicSubscriptionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *AuthorizeTopicSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AuthorizeTopicSubscriptionResponse and nil error while calling AuthorizeTopicSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAuthorizeTopicSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(AuthorizeTopicSubscriptionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.AuthorizeTopicSubscription
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AuthorizeTopicSubscriptionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AuthorizeTopicSubscriptionRequest) when calling interceptor")
					}
					return s.Meepo.AuthorizeTopicSubscription(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*AuthorizeTopicSubscriptionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*AuthorizeTopicSubscriptionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *AuthorizeTopicSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AuthorizeTopicSubscriptionResponse and nil error while calling AuthorizeTopicSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRejectInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRejectInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveRejectInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(RejectInvitationRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.RejectInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RejectInvitationRequest) (*RejectInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectInvitationRequest) when calling interceptor")
					}
					return s.Meepo.RejectInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *RejectInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectInvitationResponse and nil error while calling RejectInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(RejectInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.RejectInvitation
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RejectInvitationRequest) (*RejectInvitationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectInvitationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectInvitationRequest) when calling interceptor")
					}
					return s.Meepo.RejectInvitation(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectInvitationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectInvitationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *RejectInvitationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectInvitationResponse and nil error while calling RejectInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsCountByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetIncomingInvitationsCountByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetIncomingInvitationsCountByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetIncomingInvitationsCountByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetIncomingInvitationsCountByChannelIDRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.GetIncomingInvitationsCountByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsCountByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsCountByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetIncomingInvitationsCountByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsCountByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsCountByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetIncomingInvitationsCountByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsCountByChannelIDResponse and nil error while calling GetIncomingInvitationsCountByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsCountByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetIncomingInvitationsCountByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.GetIncomingInvitationsCountByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetIncomingInvitationsCountByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetIncomingInvitationsCountByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetIncomingInvitationsCountByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetIncomingInvitationsCountByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetIncomingInvitationsCountByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetIncomingInvitationsCountByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsCountByChannelIDResponse and nil error while calling GetIncomingInvitationsCountByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveSetPrimaryPlayer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetPrimaryPlayerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetPrimaryPlayerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveSetPrimaryPlayerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(SetPrimaryPlayerRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.SetPrimaryPlayer
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SetPrimaryPlayerRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SetPrimaryPlayerRequest) when calling interceptor")
					}
					return s.Meepo.SetPrimaryPlayer(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SetPrimaryPlayerResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SetPrimaryPlayerResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SetPrimaryPlayerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetPrimaryPlayerResponse and nil error while calling SetPrimaryPlayer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveSetPrimaryPlayerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(SetPrimaryPlayerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.SetPrimaryPlayer
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SetPrimaryPlayerRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SetPrimaryPlayerRequest) when calling interceptor")
					}
					return s.Meepo.SetPrimaryPlayer(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SetPrimaryPlayerResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SetPrimaryPlayerResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SetPrimaryPlayerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetPrimaryPlayerResponse and nil error while calling SetPrimaryPlayer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveShouldShowAd(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveShouldShowAdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveShouldShowAdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveShouldShowAdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ShouldShowAdRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.ShouldShowAd
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ShouldShowAdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ShouldShowAdRequest) when calling interceptor")
					}
					return s.Meepo.ShouldShowAd(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ShouldShowAdResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ShouldShowAdResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ShouldShowAdResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ShouldShowAdResponse and nil error while calling ShouldShowAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveShouldShowAdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ShouldShowAdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.ShouldShowAd
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ShouldShowAdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ShouldShowAdRequest) when calling interceptor")
					}
					return s.Meepo.ShouldShowAd(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ShouldShowAdResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ShouldShowAdResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ShouldShowAdResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ShouldShowAdResponse and nil error while calling ShouldShowAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectOutOfNetworkInvitations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRejectOutOfNetworkInvitationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRejectOutOfNetworkInvitationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveRejectOutOfNetworkInvitationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(RejectOutOfNetworkInvitationsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.RejectOutOfNetworkInvitations
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectOutOfNetworkInvitationsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectOutOfNetworkInvitationsRequest) when calling interceptor")
					}
					return s.Meepo.RejectOutOfNetworkInvitations(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectOutOfNetworkInvitationsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectOutOfNetworkInvitationsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *RejectOutOfNetworkInvitationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectOutOfNetworkInvitationsResponse and nil error while calling RejectOutOfNetworkInvitations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectOutOfNetworkInvitationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(RejectOutOfNetworkInvitationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.RejectOutOfNetworkInvitations
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RejectOutOfNetworkInvitationsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RejectOutOfNetworkInvitationsRequest) when calling interceptor")
					}
					return s.Meepo.RejectOutOfNetworkInvitations(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*RejectOutOfNetworkInvitationsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*RejectOutOfNetworkInvitationsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *RejectOutOfNetworkInvitationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectOutOfNetworkInvitationsResponse and nil error while calling RejectOutOfNetworkInvitations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCanAccessSquads(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCanAccessSquadsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanAccessSquadsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCanAccessSquadsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CanAccessSquadsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.CanAccessSquads
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CanAccessSquadsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CanAccessSquadsRequest) when calling interceptor")
					}
					return s.Meepo.CanAccessSquads(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CanAccessSquadsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CanAccessSquadsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CanAccessSquadsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanAccessSquadsResponse and nil error while calling CanAccessSquads. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCanAccessSquadsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CanAccessSquadsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.CanAccessSquads
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CanAccessSquadsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CanAccessSquadsRequest) when calling interceptor")
					}
					return s.Meepo.CanAccessSquads(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*CanAccessSquadsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*CanAccessSquadsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *CanAccessSquadsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanAccessSquadsResponse and nil error while calling CanAccessSquads. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitePolicyByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetInvitePolicyByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetInvitePolicyByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetInvitePolicyByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetInvitePolicyByChannelIDRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.GetInvitePolicyByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetInvitePolicyByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitePolicyByChannelIDResponse and nil error while calling GetInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitePolicyByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetInvitePolicyByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.GetInvitePolicyByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.GetInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetInvitePolicyByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitePolicyByChannelIDResponse and nil error while calling GetInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateInvitePolicyByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateInvitePolicyByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateInvitePolicyByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveUpdateInvitePolicyByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpdateInvitePolicyByChannelIDRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Meepo.UpdateInvitePolicyByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.UpdateInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpdateInvitePolicyByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateInvitePolicyByChannelIDResponse and nil error while calling UpdateInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateInvitePolicyByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpdateInvitePolicyByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Meepo.UpdateInvitePolicyByChannelID
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateInvitePolicyByChannelIDRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateInvitePolicyByChannelIDRequest) when calling interceptor")
					}
					return s.Meepo.UpdateInvitePolicyByChannelID(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateInvitePolicyByChannelIDResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateInvitePolicyByChannelIDResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpdateInvitePolicyByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateInvitePolicyByChannelIDResponse and nil error while calling UpdateInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *meepoServer) ProtocGenTwirpVersion() string {
	return "v8.0.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *meepoServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "meepo.v1", "Meepo")
}

// =======================
// InternalMeepo Interface
// =======================

// InternalMeepo contains endpoints that should ONLY be used by resources
// managed by the Meepo project. This service is NOT meant for other Twitch
// internal services and external clients.
type InternalMeepo interface {
	// LivecheckChannels checks all active memberships whether they are still
	// live, and removes memberships that are not live.
	LivecheckChannels(context.Context, *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error)

	// DeleteExpiredData hard deletes all data that have expired past the TTL
	// set by data compliance obligations.
	DeleteExpiredData(context.Context, *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error)

	// DestroyUser removes the channel from its current squad, deletes pending
	// incoming invitations, and removes all user preference data related to
	// squad stream.
	// NOTE: This should only be used to address data compliance obligations.
	DestroyUser(context.Context, *DestroyUserRequest) (*DestroyUserResponse, error)

	// DeleteUser removes the channel from its current squad and deletes pending
	// incoming invitations.
	DeleteUser(context.Context, *DeleteUserRequest) (*DeleteUserResponse, error)
}

// =============================
// InternalMeepo Protobuf Client
// =============================

type internalMeepoProtobufClient struct {
	client      HTTPClient
	urls        [4]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewInternalMeepoProtobufClient creates a Protobuf client that implements the InternalMeepo interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewInternalMeepoProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) InternalMeepo {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(clientOpts.PathPrefix(), "meepo.v1", "InternalMeepo")
	urls := [4]string{
		serviceURL + "LivecheckChannels",
		serviceURL + "DeleteExpiredData",
		serviceURL + "DestroyUser",
		serviceURL + "DeleteUser",
	}

	return &internalMeepoProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *internalMeepoProtobufClient) LivecheckChannels(ctx context.Context, in *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	caller := c.callLivecheckChannels
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LivecheckChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LivecheckChannelsRequest) when calling interceptor")
					}
					return c.callLivecheckChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LivecheckChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LivecheckChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoProtobufClient) callLivecheckChannels(ctx context.Context, in *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
	out := new(LivecheckChannelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *internalMeepoProtobufClient) DeleteExpiredData(ctx context.Context, in *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExpiredData")
	caller := c.callDeleteExpiredData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteExpiredDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteExpiredDataRequest) when calling interceptor")
					}
					return c.callDeleteExpiredData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteExpiredDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteExpiredDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoProtobufClient) callDeleteExpiredData(ctx context.Context, in *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
	out := new(DeleteExpiredDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *internalMeepoProtobufClient) DestroyUser(ctx context.Context, in *DestroyUserRequest) (*DestroyUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "DestroyUser")
	caller := c.callDestroyUser
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DestroyUserRequest) (*DestroyUserResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DestroyUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DestroyUserRequest) when calling interceptor")
					}
					return c.callDestroyUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DestroyUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DestroyUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoProtobufClient) callDestroyUser(ctx context.Context, in *DestroyUserRequest) (*DestroyUserResponse, error) {
	out := new(DestroyUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *internalMeepoProtobufClient) DeleteUser(ctx context.Context, in *DeleteUserRequest) (*DeleteUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUser")
	caller := c.callDeleteUser
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteUserRequest) (*DeleteUserResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteUserRequest) when calling interceptor")
					}
					return c.callDeleteUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoProtobufClient) callDeleteUser(ctx context.Context, in *DeleteUserRequest) (*DeleteUserResponse, error) {
	out := new(DeleteUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// InternalMeepo JSON Client
// =========================

type internalMeepoJSONClient struct {
	client      HTTPClient
	urls        [4]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewInternalMeepoJSONClient creates a JSON client that implements the InternalMeepo interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewInternalMeepoJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) InternalMeepo {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(clientOpts.PathPrefix(), "meepo.v1", "InternalMeepo")
	urls := [4]string{
		serviceURL + "LivecheckChannels",
		serviceURL + "DeleteExpiredData",
		serviceURL + "DestroyUser",
		serviceURL + "DeleteUser",
	}

	return &internalMeepoJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *internalMeepoJSONClient) LivecheckChannels(ctx context.Context, in *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	caller := c.callLivecheckChannels
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LivecheckChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LivecheckChannelsRequest) when calling interceptor")
					}
					return c.callLivecheckChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LivecheckChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LivecheckChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoJSONClient) callLivecheckChannels(ctx context.Context, in *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
	out := new(LivecheckChannelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *internalMeepoJSONClient) DeleteExpiredData(ctx context.Context, in *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExpiredData")
	caller := c.callDeleteExpiredData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteExpiredDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteExpiredDataRequest) when calling interceptor")
					}
					return c.callDeleteExpiredData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteExpiredDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteExpiredDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoJSONClient) callDeleteExpiredData(ctx context.Context, in *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
	out := new(DeleteExpiredDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *internalMeepoJSONClient) DestroyUser(ctx context.Context, in *DestroyUserRequest) (*DestroyUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "DestroyUser")
	caller := c.callDestroyUser
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DestroyUserRequest) (*DestroyUserResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DestroyUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DestroyUserRequest) when calling interceptor")
					}
					return c.callDestroyUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DestroyUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DestroyUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoJSONClient) callDestroyUser(ctx context.Context, in *DestroyUserRequest) (*DestroyUserResponse, error) {
	out := new(DestroyUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *internalMeepoJSONClient) DeleteUser(ctx context.Context, in *DeleteUserRequest) (*DeleteUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUser")
	caller := c.callDeleteUser
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteUserRequest) (*DeleteUserResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteUserRequest) when calling interceptor")
					}
					return c.callDeleteUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *internalMeepoJSONClient) callDeleteUser(ctx context.Context, in *DeleteUserRequest) (*DeleteUserResponse, error) {
	out := new(DeleteUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// InternalMeepo Server Handler
// ============================

type internalMeepoServer struct {
	InternalMeepo
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
}

// NewInternalMeepoServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewInternalMeepoServer(svc InternalMeepo, opts ...interface{}) TwirpServer {
	serverOpts := twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(&serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(&serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T on NewInternalMeepoServer", o))
		}
	}

	return &internalMeepoServer{
		InternalMeepo:    svc,
		pathPrefix:       serverOpts.PathPrefix(),
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		hooks:            serverOpts.Hooks,
		jsonSkipDefaults: serverOpts.JSONSkipDefaults,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *internalMeepoServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *internalMeepoServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// InternalMeepoPathPrefix is a convenience constant that could used to identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// that add a "/twirp" prefix by default, and use CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const InternalMeepoPathPrefix = "/twirp/meepo.v1.InternalMeepo/"

func (s *internalMeepoServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "meepo.v1.InternalMeepo" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "LivecheckChannels":
		s.serveLivecheckChannels(ctx, resp, req)
		return
	case "DeleteExpiredData":
		s.serveDeleteExpiredData(ctx, resp, req)
		return
	case "DestroyUser":
		s.serveDestroyUser(ctx, resp, req)
		return
	case "DeleteUser":
		s.serveDeleteUser(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *internalMeepoServer) serveLivecheckChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLivecheckChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLivecheckChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *internalMeepoServer) serveLivecheckChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(LivecheckChannelsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.InternalMeepo.LivecheckChannels
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LivecheckChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LivecheckChannelsRequest) when calling interceptor")
					}
					return s.InternalMeepo.LivecheckChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LivecheckChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LivecheckChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *LivecheckChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LivecheckChannelsResponse and nil error while calling LivecheckChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveLivecheckChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(LivecheckChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.InternalMeepo.LivecheckChannels
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*LivecheckChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*LivecheckChannelsRequest) when calling interceptor")
					}
					return s.InternalMeepo.LivecheckChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*LivecheckChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*LivecheckChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *LivecheckChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LivecheckChannelsResponse and nil error while calling LivecheckChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveDeleteExpiredData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteExpiredDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteExpiredDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *internalMeepoServer) serveDeleteExpiredDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExpiredData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(DeleteExpiredDataRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.InternalMeepo.DeleteExpiredData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteExpiredDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteExpiredDataRequest) when calling interceptor")
					}
					return s.InternalMeepo.DeleteExpiredData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteExpiredDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteExpiredDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteExpiredDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteExpiredDataResponse and nil error while calling DeleteExpiredData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveDeleteExpiredDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExpiredData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(DeleteExpiredDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.InternalMeepo.DeleteExpiredData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteExpiredDataRequest) (*DeleteExpiredDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteExpiredDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteExpiredDataRequest) when calling interceptor")
					}
					return s.InternalMeepo.DeleteExpiredData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteExpiredDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteExpiredDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteExpiredDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteExpiredDataResponse and nil error while calling DeleteExpiredData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveDestroyUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDestroyUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDestroyUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *internalMeepoServer) serveDestroyUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DestroyUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(DestroyUserRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.InternalMeepo.DestroyUser
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DestroyUserRequest) (*DestroyUserResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DestroyUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DestroyUserRequest) when calling interceptor")
					}
					return s.InternalMeepo.DestroyUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DestroyUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DestroyUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DestroyUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DestroyUserResponse and nil error while calling DestroyUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveDestroyUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DestroyUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(DestroyUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.InternalMeepo.DestroyUser
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DestroyUserRequest) (*DestroyUserResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DestroyUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DestroyUserRequest) when calling interceptor")
					}
					return s.InternalMeepo.DestroyUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DestroyUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DestroyUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DestroyUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DestroyUserResponse and nil error while calling DestroyUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveDeleteUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *internalMeepoServer) serveDeleteUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(DeleteUserRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.InternalMeepo.DeleteUser
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteUserRequest) (*DeleteUserResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteUserRequest) when calling interceptor")
					}
					return s.InternalMeepo.DeleteUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteUserResponse and nil error while calling DeleteUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: true, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveDeleteUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(DeleteUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.InternalMeepo.DeleteUser
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteUserRequest) (*DeleteUserResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteUserRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteUserRequest) when calling interceptor")
					}
					return s.InternalMeepo.DeleteUser(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteUserResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteUserResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteUserResponse and nil error while calling DeleteUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *internalMeepoServer) ProtocGenTwirpVersion() string {
	return "v8.0.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *internalMeepoServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "meepo.v1", "InternalMeepo")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// google.golang.org/protobuf/types/descriptorpb.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchaged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//       returns => "/twirp/my.pkg.MyService/"
// e.g.: baseServicePath("", "", "MyService")
//       returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v8.0.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	marshaler := &protojson.MarshalOptions{UseProtoNames: true}
	reqBytes, err := marshaler.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, bytes.NewReader(reqBytes), "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	d := json.NewDecoder(resp.Body)
	rawRespBody := json.RawMessage{}
	if err := d.Decode(&rawRespBody); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawRespBody, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1659 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0x6f, 0x53, 0xdb, 0x46,
	0x13, 0x8f, 0xcd, 0x03, 0x98, 0x35, 0x21, 0x20, 0x08, 0x06, 0x01, 0x79, 0x82, 0x02, 0x2d, 0x69,
	0x13, 0xd3, 0x42, 0xa7, 0x69, 0x27, 0x49, 0x67, 0x08, 0x4e, 0x53, 0x67, 0x20, 0x78, 0x64, 0xc8,
	0x0c, 0x4d, 0x66, 0x34, 0x42, 0xba, 0xc4, 0x4a, 0x8c, 0x24, 0xa4, 0xb3, 0x5d, 0xf7, 0x55, 0xdf,
	0x37, 0xfd, 0x04, 0xfd, 0x0a, 0xfd, 0x20, 0x7d, 0xdf, 0x2f, 0xd0, 0x8f, 0xd2, 0xd1, 0xdd, 0xd9,
	0x77, 0xfa, 0x6b, 0x3b, 0x90, 0x57, 0x70, 0x77, 0x7b, 0xbb, 0xfb, 0xdb, 0xbb, 0xdd, 0xfb, 0xad,
	0x0c, 0x37, 0xcf, 0x11, 0x72, 0x9d, 0x6d, 0xcf, 0x35, 0xb6, 0xc9, 0x7f, 0x65, 0xd7, 0x73, 0xb0,
	0x23, 0x15, 0xe8, 0xa0, 0xfd, 0xb5, 0xbc, 0x28, 0x08, 0x38, 0x26, 0x6a, 0xfa, 0x54, 0x42, 0x79,
	0x08, 0xf2, 0x33, 0x84, 0xeb, 0x17, 0x2d, 0xdd, 0x7c, 0xd2, 0xdd, 0x6f, 0xe8, 0xb6, 0x8d, 0x9a,
	0xd5, 0x8a, 0x8a, 0x2e, 0x5a, 0xc8, 0xc7, 0xd2, 0x1a, 0x80, 0x41, 0xe7, 0x34, 0xcb, 0x5c, 0xca,
	0xdd, 0xce, 0x6d, 0x4d, 0xa9, 0x53, 0x6c, 0xa6, 0x6a, 0x2a, 0x15, 0x58, 0x49, 0xdc, 0xec, 0xbb,
	0x8e, 0xed, 0x23, 0x69, 0x13, 0xc6, 0xfd, 0x60, 0x8d, 0x6c, 0x2c, 0xee, 0xdc, 0x28, 0xf7, 0xbc,
	0x29, 0x93, 0x2d, 0x2a, 0x5d, 0x55, 0x36, 0x61, 0x9e, 0x6b, 0xe1, 0xb6, 0x67, 0x20, 0xdf, 0xb7,
	0x99, 0xb7, 0x4c, 0xe5, 0x31, 0x2c, 0x84, 0xc5, 0x46, 0xb3, 0xd2, 0x81, 0xd2, 0xbe, 0x87, 0x74,
	0x8c, 0x0e, 0xd1, 0xf9, 0x19, 0xf2, 0xfc, 0x86, 0xe5, 0xf6, 0x2c, 0x6d, 0xc0, 0x0c, 0xd6, 0xbd,
	0xb7, 0x08, 0x6b, 0x2d, 0x1f, 0x79, 0x1c, 0xe9, 0x34, 0x9d, 0x3d, 0xf1, 0x91, 0x57, 0x35, 0xa5,
	0x15, 0x98, 0x32, 0xf4, 0x66, 0x93, 0x0a, 0xe4, 0x89, 0x40, 0x81, 0x4e, 0x54, 0x4d, 0x69, 0x19,
	0x0a, 0xc4, 0x4c, 0xb0, 0x36, 0x46, 0xd6, 0x26, 0xc9, 0xb8, 0x6a, 0x2a, 0x07, 0xb0, 0x14, 0x37,
	0xcc, 0x7c, 0xff, 0x0a, 0xe0, 0xbc, 0x3f, 0xcb, 0x00, 0xcc, 0x72, 0x00, 0x74, 0x87, 0x2a, 0xc8,
	0x28, 0x17, 0x20, 0x9d, 0xb8, 0xa6, 0x8e, 0x11, 0x05, 0x97, 0x1c, 0x2b, 0xa9, 0x0c, 0x13, 0x3e,
	0xd6, 0x71, 0xcb, 0x27, 0x8e, 0xce, 0xec, 0x2c, 0x46, 0x82, 0x52, 0xae, 0x93, 0x55, 0x95, 0x49,
	0x85, 0xb1, 0x8d, 0x85, 0xb1, 0x29, 0x8f, 0x60, 0x3e, 0x64, 0x72, 0xb4, 0xb8, 0x37, 0x60, 0xee,
	0x00, 0xe9, 0xed, 0xb0, 0xbf, 0x2b, 0x30, 0x45, 0x31, 0xf1, 0x60, 0x17, 0xe8, 0x44, 0x24, 0x96,
	0xf9, 0x50, 0x2c, 0xb3, 0xfd, 0x7c, 0x08, 0x92, 0x68, 0x69, 0x34, 0x37, 0xdf, 0xc1, 0xbc, 0x8a,
	0xce, 0x9d, 0x36, 0x3b, 0xa5, 0xa1, 0x1c, 0xfd, 0xd8, 0x1b, 0xf1, 0x18, 0x16, 0xc2, 0xb6, 0x46,
	0x73, 0x55, 0x86, 0xa5, 0x03, 0xab, 0x8d, 0x8c, 0x06, 0x32, 0xde, 0xb3, 0xa4, 0xf3, 0x99, 0xbf,
	0xca, 0x0a, 0x2c, 0x27, 0xac, 0x51, 0xfd, 0x4a, 0xbb, 0x97, 0x02, 0x55, 0xbb, 0x6d, 0x61, 0x1d,
	0x5b, 0x8e, 0x2d, 0xe0, 0xf4, 0x91, 0x6d, 0x86, 0x70, 0xd2, 0x89, 0xaa, 0x29, 0xad, 0xc3, 0xb4,
	0x87, 0x0c, 0xcb, 0xb5, 0x90, 0x8d, 0x39, 0xd4, 0x62, 0x7f, 0x6e, 0xd0, 0xc1, 0xd4, 0x7a, 0x19,
	0x20, 0xda, 0x65, 0x98, 0xbf, 0x01, 0xb0, 0xfa, 0xb3, 0x0c, 0xf8, 0x02, 0x07, 0x2e, 0xec, 0x10,
	0xe4, 0x94, 0x37, 0xb0, 0xf5, 0x0c, 0xe1, 0xaa, 0x6d, 0x38, 0xe7, 0x96, 0xfd, 0x96, 0x0b, 0xf9,
	0x23, 0xd7, 0xb0, 0xcc, 0x43, 0x54, 0x0c, 0xb8, 0x3b, 0x84, 0x1d, 0x06, 0xe5, 0x5b, 0x28, 0x72,
	0x17, 0xfd, 0xa5, 0xdc, 0xed, 0xb1, 0x54, 0x2c, 0xa2, 0xa0, 0x72, 0x00, 0x12, 0x0d, 0x4f, 0x28,
	0x45, 0x96, 0xa1, 0xe0, 0x74, 0x6c, 0xf1, 0x40, 0x26, 0xc9, 0x78, 0x90, 0xcb, 0x8f, 0x60, 0x3e,
	0xa4, 0x6d, 0xb4, 0xbb, 0xf5, 0x47, 0x0e, 0x6e, 0x11, 0xc4, 0x02, 0x52, 0x22, 0xc0, 0xe3, 0x29,
	0x5e, 0xec, 0x5c, 0x46, 0x7a, 0x46, 0x13, 0x62, 0xb7, 0x5f, 0x93, 0xc6, 0x48, 0x4d, 0x5a, 0x49,
	0x8a, 0x4c, 0xa4, 0x30, 0x29, 0xa7, 0xf0, 0xff, 0x54, 0x77, 0x2e, 0x19, 0xf6, 0x57, 0x50, 0xda,
	0x33, 0x0c, 0xe4, 0xe2, 0x78, 0x36, 0xdc, 0x81, 0xeb, 0x5c, 0x52, 0x78, 0x0f, 0xf8, 0xe4, 0xa0,
	0x53, 0xa8, 0xc1, 0x52, 0x5c, 0xf9, 0xa5, 0xae, 0xfc, 0x2b, 0x28, 0x55, 0x50, 0x13, 0x25, 0x25,
	0xef, 0x95, 0xb8, 0x1b, 0x57, 0x7e, 0x29, 0x77, 0x5f, 0xc2, 0xfa, 0x5e, 0x0b, 0x37, 0x1c, 0xcf,
	0xfa, 0x15, 0x1d, 0x3b, 0xae, 0x65, 0xd4, 0x5b, 0x67, 0xbe, 0xe1, 0x59, 0xae, 0xe8, 0xf8, 0x02,
	0x8c, 0xe3, 0x60, 0x8d, 0x39, 0x4c, 0x07, 0xd9, 0x9e, 0x56, 0x41, 0xc9, 0xd2, 0xcb, 0x7c, 0x0e,
	0x22, 0xe2, 0x6b, 0x7a, 0x4f, 0x90, 0x46, 0xa4, 0xa0, 0x4e, 0x5b, 0x7e, 0x7f, 0xb3, 0x19, 0x44,
	0x54, 0x45, 0xef, 0x90, 0xf1, 0xa9, 0x2e, 0x40, 0x5c, 0xf9, 0xa5, 0x22, 0xfa, 0x1e, 0xee, 0x27,
	0xd7, 0xa2, 0x7d, 0xa7, 0x65, 0xe3, 0x2b, 0x2e, 0x7c, 0x3f, 0x42, 0x79, 0x58, 0x63, 0x0c, 0xd4,
	0x02, 0x8c, 0x1b, 0xc1, 0x1a, 0x31, 0x34, 0xa6, 0xd2, 0x81, 0xf2, 0x21, 0x07, 0xa5, 0x3a, 0xc2,
	0x35, 0xcf, 0x3a, 0xd7, 0xbd, 0x6e, 0xad, 0xa9, 0x77, 0x43, 0x6f, 0xab, 0x89, 0xda, 0x96, 0x81,
	0x84, 0x37, 0x87, 0x4e, 0x64, 0x93, 0x80, 0xef, 0x61, 0xd9, 0xa5, 0xfa, 0x34, 0x97, 0x28, 0xd4,
	0x04, 0x98, 0xf4, 0xed, 0x59, 0x74, 0x45, 0x83, 0xfb, 0x7d, 0xc2, 0x7a, 0x02, 0x4b, 0x71, 0x6f,
	0x18, 0x80, 0x4c, 0xb5, 0xb9, 0x4c, 0xb5, 0xff, 0xe4, 0x61, 0xbe, 0xde, 0x70, 0x5a, 0x4d, 0xb3,
	0xde, 0x70, 0x3a, 0x7b, 0xfd, 0x1a, 0xfe, 0x18, 0x26, 0x75, 0x53, 0xc3, 0x5d, 0x17, 0x11, 0x05,
	0x33, 0x3b, 0x1b, 0x42, 0xd9, 0x8d, 0xcb, 0x97, 0xf7, 0xcc, 0xe3, 0xae, 0x8b, 0xd4, 0x09, 0x9d,
	0xfc, 0x8d, 0x1c, 0x60, 0x3e, 0xe1, 0x00, 0x79, 0xfc, 0xc6, 0x22, 0xf1, 0x2b, 0xc1, 0x64, 0x8f,
	0xcc, 0xfe, 0x8f, 0x2c, 0x4d, 0xb4, 0x28, 0x8d, 0xad, 0x42, 0x91, 0xc1, 0x23, 0x7e, 0x8d, 0x13,
	0xbf, 0xb6, 0xb2, 0xfd, 0xa2, 0x78, 0x89, 0x6f, 0xe0, 0xf6, 0xff, 0x57, 0x76, 0x61, 0x82, 0x7a,
	0x2c, 0x4d, 0x43, 0xa1, 0xa6, 0x3e, 0xd5, 0xd4, 0xa3, 0x83, 0x83, 0xd9, 0x6b, 0xc1, 0xe8, 0xb0,
	0x5a, 0xa1, 0xa3, 0x9c, 0x74, 0x1d, 0xa6, 0x6a, 0x47, 0xf5, 0x63, 0x3a, 0xcc, 0x2b, 0x5b, 0x00,
	0x5c, 0x9d, 0x54, 0x84, 0xc9, 0x9a, 0x5a, 0x3d, 0xdc, 0x53, 0x4f, 0x67, 0xaf, 0x05, 0x92, 0xf5,
	0xa7, 0xfb, 0x47, 0x2f, 0x2a, 0xc1, 0x30, 0xa7, 0x6c, 0xc3, 0x42, 0xd8, 0x19, 0x76, 0x50, 0x25,
	0x98, 0xf4, 0x1b, 0x4e, 0x47, 0xd3, 0x7b, 0x69, 0x3d, 0xe1, 0x13, 0x01, 0xe5, 0x0c, 0x36, 0x68,
	0xce, 0x1d, 0xb5, 0xf0, 0xd1, 0x9b, 0x17, 0x08, 0x77, 0x1c, 0xef, 0xbd, 0x70, 0x77, 0xaf, 0x22,
	0x31, 0x3e, 0x87, 0xcd, 0x01, 0x36, 0x18, 0xd9, 0x7a, 0x00, 0x8b, 0xfb, 0xba, 0x1d, 0x3c, 0x02,
	0xbe, 0x4f, 0x9e, 0xac, 0x21, 0xcd, 0x2b, 0xbf, 0xe7, 0xa0, 0x14, 0xdb, 0xc9, 0xa0, 0x7f, 0x01,
	0x73, 0x86, 0x6e, 0x6b, 0x3a, 0x59, 0xd3, 0x48, 0x42, 0xf8, 0x2c, 0x08, 0x37, 0x8c, 0xf0, 0x1e,
	0xa9, 0x02, 0xb7, 0xa8, 0x80, 0x86, 0xd1, 0xb9, 0xeb, 0x78, 0xba, 0x67, 0x35, 0xbb, 0x5a, 0xcb,
	0xd6, 0xdb, 0xba, 0xd5, 0xd4, 0xcf, 0x9a, 0x88, 0x60, 0x2b, 0xa8, 0xab, 0x54, 0xea, 0x98, 0x0b,
	0x9d, 0x70, 0x19, 0x45, 0x83, 0xf5, 0xde, 0x03, 0x8c, 0x6a, 0x4e, 0xd3, 0x32, 0xba, 0x57, 0x5c,
	0x69, 0x6c, 0x50, 0xb2, 0x0c, 0x30, 0xe0, 0x3f, 0xb1, 0x82, 0x8c, 0x34, 0x97, 0xc8, 0xb0, 0x7c,
	0xba, 0x13, 0xa9, 0x9a, 0x4c, 0x43, 0x68, 0xc0, 0xaa, 0x36, 0x1b, 0x29, 0x7f, 0xe5, 0x60, 0x83,
	0xb6, 0x33, 0x9f, 0x0e, 0x54, 0xdc, 0xdd, 0xb1, 0x8f, 0x75, 0xf7, 0x02, 0x36, 0x07, 0x78, 0x7b,
	0xe5, 0x11, 0x92, 0x7b, 0x64, 0xe0, 0xe9, 0x2f, 0xae, 0xe5, 0x21, 0xb3, 0xa2, 0x63, 0xbd, 0xd7,
	0x5f, 0xfc, 0x00, 0xcb, 0x09, 0x6b, 0xcc, 0x85, 0xa0, 0x4f, 0x70, 0x3a, 0xbe, 0x66, 0x12, 0x09,
	0x93, 0xbd, 0x04, 0xc5, 0x60, 0x8e, 0x6e, 0x32, 0x95, 0x5d, 0x90, 0x2a, 0xc8, 0xc7, 0x9e, 0xd3,
	0x0d, 0xba, 0xea, 0x21, 0x33, 0xe2, 0x26, 0xcc, 0x87, 0x36, 0xb1, 0x0c, 0xdb, 0x81, 0x39, 0xaa,
	0x76, 0x04, 0x55, 0x0b, 0x81, 0x7d, 0xbe, 0x87, 0x6a, 0xda, 0xf9, 0x7b, 0x16, 0xc6, 0x0f, 0x83,
	0x30, 0x49, 0x67, 0xe2, 0xb7, 0x88, 0x7e, 0x90, 0x25, 0xa1, 0x6e, 0xa7, 0x7f, 0x2d, 0x91, 0x37,
	0x07, 0x48, 0xb1, 0x30, 0x1d, 0xc2, 0xb4, 0xf8, 0x21, 0x43, 0x5a, 0x4b, 0xda, 0xc6, 0xb5, 0xde,
	0x4a, 0x5b, 0x66, 0xea, 0x4e, 0x61, 0x36, 0xfa, 0x7d, 0x41, 0x5a, 0xe7, 0x7b, 0x52, 0x3e, 0x7a,
	0xc8, 0x4a, 0x96, 0x08, 0x53, 0xfd, 0x1c, 0x8a, 0x42, 0xe7, 0x2f, 0xad, 0xf2, 0x2d, 0xf1, 0x6f,
	0x10, 0xf2, 0x5a, 0xca, 0x2a, 0xd3, 0xf5, 0x0c, 0x80, 0x77, 0xe7, 0x92, 0x40, 0xfe, 0x63, 0x5f,
	0x07, 0xe4, 0xd5, 0xe4, 0x45, 0x1e, 0x3e, 0xb1, 0x7b, 0x16, 0xc3, 0x97, 0xd0, 0xc1, 0x8b, 0xe1,
	0x4b, 0x6c, 0xba, 0xfb, 0xe1, 0xe3, 0x45, 0x3c, 0x1e, 0xbe, 0x18, 0x43, 0x8c, 0x87, 0x2f, 0x81,
	0xe7, 0x7d, 0xc8, 0xb1, 0xe2, 0x99, 0xd5, 0x3e, 0x4a, 0x3b, 0xa1, 0xf3, 0x1d, 0xaa, 0xa7, 0x95,
	0x77, 0x47, 0xda, 0xc3, 0x4f, 0x53, 0xe8, 0x0c, 0xc5, 0xd3, 0x8c, 0xb7, 0x9f, 0xe2, 0x69, 0x26,
	0xb5, 0x93, 0x36, 0x94, 0x52, 0xfa, 0x32, 0x69, 0x2b, 0xe2, 0x5b, 0x6a, 0x27, 0x29, 0xdf, 0x1d,
	0x42, 0x92, 0x9f, 0x52, 0xb4, 0x9f, 0x12, 0x4f, 0x29, 0xa5, 0x91, 0x13, 0x4f, 0x29, 0xb5, 0x1d,
	0x3b, 0x85, 0xd9, 0x68, 0xef, 0x23, 0xaa, 0x4e, 0x69, 0xba, 0x44, 0xd5, 0xa9, 0xad, 0x53, 0x07,
	0xe4, 0xf4, 0x66, 0x45, 0xfa, 0x52, 0x70, 0x6e, 0x50, 0xab, 0x24, 0xdf, 0x1b, 0x4e, 0x98, 0x63,
	0x8a, 0x76, 0x1f, 0x22, 0xa6, 0x94, 0xb6, 0x47, 0xc4, 0x94, 0xda, 0xbc, 0xfc, 0x99, 0x83, 0xcf,
	0x86, 0x6b, 0x0d, 0xa4, 0x07, 0x83, 0x6e, 0x69, 0x4a, 0xe7, 0x22, 0x7f, 0x37, 0xfa, 0x46, 0x0e,
	0x3c, 0x4a, 0xf0, 0x45, 0xe0, 0x29, 0xad, 0x88, 0x08, 0x3c, 0xb5, 0x3f, 0x38, 0x84, 0x69, 0x91,
	0x8e, 0x8a, 0x75, 0x27, 0x81, 0x33, 0x8b, 0x75, 0x27, 0x91, 0xc5, 0xfe, 0x96, 0x83, 0xb5, 0x4c,
	0x26, 0x29, 0x95, 0xa3, 0xa7, 0x91, 0x4d, 0x6b, 0xe5, 0xed, 0xa1, 0xe5, 0x99, 0x0b, 0x2f, 0xe1,
	0x46, 0x84, 0x68, 0x4a, 0xb7, 0x85, 0xb4, 0x4f, 0x64, 0xaf, 0xf2, 0x7a, 0x86, 0x04, 0xbf, 0xf6,
	0xe9, 0x94, 0x4e, 0xbc, 0xf6, 0x03, 0x99, 0xa5, 0x78, 0xed, 0x87, 0x60, 0x89, 0x41, 0x4c, 0x33,
	0xd9, 0x92, 0x18, 0xd3, 0x61, 0x48, 0xa0, 0x18, 0xd3, 0xa1, 0x68, 0xd8, 0xce, 0xbf, 0x79, 0xb8,
	0x5e, 0xb5, 0x31, 0xf2, 0x6c, 0xbd, 0x49, 0x29, 0xc5, 0x6b, 0x98, 0x8b, 0x7d, 0x92, 0x95, 0x84,
	0x0b, 0x97, 0xf6, 0x2d, 0x57, 0xbe, 0x93, 0x29, 0xc3, 0x20, 0xbf, 0xee, 0x91, 0x20, 0x81, 0x90,
	0x49, 0xb1, 0xda, 0x14, 0x67, 0x72, 0xa2, 0xf6, 0x74, 0x46, 0xf7, 0x1c, 0x8a, 0x02, 0xf3, 0x12,
	0x9f, 0x8c, 0x38, 0x8b, 0x13, 0x9f, 0x8c, 0x04, 0xba, 0x16, 0x10, 0x00, 0x4e, 0xbd, 0x44, 0x02,
	0x10, 0x23, 0x71, 0xf2, 0x6a, 0xf2, 0x22, 0x55, 0xf4, 0xa4, 0xfc, 0xf3, 0x3d, 0xc3, 0x31, 0x51,
	0xf9, 0x5d, 0xcb, 0xc7, 0x96, 0x5d, 0xc6, 0xed, 0x6d, 0xdc, 0xb1, 0xb0, 0xd1, 0xb8, 0x8f, 0xda,
	0xc8, 0xc6, 0xfe, 0x76, 0xe4, 0xa7, 0xb0, 0xb3, 0x09, 0xf2, 0x4b, 0xd7, 0xee, 0x7f, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xda, 0x40, 0xc1, 0x58, 0x24, 0x1b, 0x00, 0x00,
}
