variable "name" {
  type        = string
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)."
}

variable "service_name" {
  type        = string
  description = "Service name used for alphanumeric only AWS resourcing (RDS)."
}

variable "team_name" {
  type        = string
  description = "Twitch team name.  Used for AWS resourcing."
}

variable "environment" {
  type        = string
  description = "Service environment."
}

variable "team_display_name" {
  type        = string
  description = "Twitch team name, used for display purposes."
}

variable "owner" {
  type        = string
  description = "Team email alias."
}

variable "project" {
  type        = string
  description = "GitHub repository name."
}

variable "lambda_name" {
  type        = string
  description = "Name of the Lambda used for AWS resourcing (application, tagging, IAM, etc.)."
  default     = "eventbus"
}

variable "lambda_directory" {
  type        = string
  description = "Directory of the lambda source code."
  default     = "../../../build/lambda/eventbus"
}

variable "lambda_zip_filename" {
  type        = string
  default     = "eventbus.zip"
  description = "Zip filename for the lambda locally."
}

variable "meepo_host" {
  type        = string
  description = "Hostname of meepo."
}

variable "private_subnets" {
  type        = list(string)
  description = "The subnets in the VPC that Twitch infrastructure should be created in."
}

variable "twitch_subnets_sg" {
  type        = list(string)
  description = "The security groups of the subnets in the VPC that Twitch infrastructure should be created in."
}
