data "aws_elastic_beanstalk_hosted_zone" "current" {
}

output "elb_dns_name" {
  value = aws_elastic_beanstalk_environment.web.cname
}

output "elb_zone_id" {
  value = data.aws_elastic_beanstalk_hosted_zone.current.id
}

output "elb_name" {
  value = aws_elastic_beanstalk_environment.web.load_balancers[0]
}

output "app_name" {
  value = aws_elastic_beanstalk_application.app.name
}

output "asg_name" {
  value = aws_elastic_beanstalk_environment.web.autoscaling_groups[0]
}

output "environment_name" {
  value = aws_elastic_beanstalk_environment.web.name
}

output "elasticache_cluster_id" {
  value = aws_elasticache_cluster.cache.cluster_id
}
