variable "name" {
  type        = string
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "service_name" {
  type        = string
  description = "Service name used for alphanumeric only AWS resourcing (RDS)"
}

variable "project" {
  type        = string
  description = "GitHub repository name"
}

variable "team_display_name" {
  type        = string
  description = "Twitch team name, used for display purposes"
}

variable "owner" {
  type        = string
  description = "Team email alias"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "private_subnets" {
  type        = list(string)
  description = "The subnets in the VPC that Twitch infrastructure should be created in"
}

variable "twitch_subnets_sg" {
  type        = list(string)
  description = "The security groups of the subnets in the VPC that Twitch infrastructure should be created in"
}

variable "rds_instance_type" {
  type        = string
  description = "The instance type of the rds cluster"
  default     = "db.m4.xlarge"
}

variable "rds_storage" {
  type    = string
  default = 1000
}
