resource "aws_vpc_endpoint" "artifactory" {
  vpc_id             = var.vpc_id
  vpc_endpoint_type  = "Interface"
  service_name       = var.artifactory_service_name
  subnet_ids         = var.private_subnets
  security_group_ids = var.security_groups

  tags = {
    Environment = var.environment
    Name        = "artifactory-unified"
    Owner       = var.owner
    Project     = var.project
    Team        = var.team_display_name
  }
}

resource "aws_route53_zone" "artifactory" {
  name = var.artifactory_dns_name
  vpc {
    vpc_id = var.vpc_id
  }
}

resource "aws_route53_record" "artifactory" {
  zone_id = aws_route53_zone.artifactory.zone_id
  name    = aws_route53_zone.artifactory.name
  type    = "A"

  alias {
    name                   = aws_vpc_endpoint.artifactory.dns_entry.0.dns_name
    zone_id                = aws_vpc_endpoint.artifactory.dns_entry.0.hosted_zone_id
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_wildcard" {
  zone_id = aws_route53_zone.artifactory.zone_id
  name    = "*.${aws_route53_zone.artifactory.name}"
  type    = "A"

  alias {
    name                   = aws_vpc_endpoint.artifactory.dns_entry.0.dns_name
    zone_id                = aws_vpc_endpoint.artifactory.dns_entry.0.hosted_zone_id
    evaluate_target_health = false
  }
}
