resource "aws_vpc_endpoint" "friendship" {
  vpc_id             = var.vpc_id
  vpc_endpoint_type  = "Interface"
  service_name       = var.friendship_service_name
  subnet_ids         = var.private_subnets
  security_group_ids = var.security_groups

  tags = {
    Environment = var.environment
    Name        = "friendship-${var.environment}"
    Owner       = var.owner
    Project     = var.project
    Team        = var.team_display_name
  }
}

resource "aws_route53_zone" "friendship" {
  name = var.friendship_dns_name
  vpc {
    vpc_id = var.vpc_id
  }
}

resource "aws_route53_record" "friendship" {
  zone_id = aws_route53_zone.friendship.zone_id
  name    = aws_route53_zone.friendship.name
  type    = "A"

  alias {
    name                   = aws_vpc_endpoint.friendship.dns_entry.0.dns_name
    zone_id                = aws_vpc_endpoint.friendship.dns_entry.0.hosted_zone_id
    evaluate_target_health = false
  }
}
