terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/meepo/parameters/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "admin_users" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.admin_users"
  description = "Comma separated list of user IDs that can perform any operation"

  development = "237755203,40529315,138289128,60752857,153817938,267332047,48276979,31825889"
  staging     = "237755203,40529315,138289128,60752857,153817938,267332047,48276979,31825889"
  production  = "237755203,40529315,138289128,60752857,153817938,267332047,48276979,31825889"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "ads_debug_logging_enabled" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.ads_debug_logging_enabled"
  description = "Boolean value that determines whether logging for ads related endpoints should be enabled"

  development = "false"
  staging     = "false"
  production  = "false"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "always_on_channels" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.always_on_channels"
  description = "Comma seperated userIDs for channels whose squad that will not be cleaned up and removed"

  development = "60752857,442455983,442456926,442457437,442459612"
  staging     = "60752857,442455983,442456926,442457437,442459612"
  production  = "102931304,102931354,102931380,118353338,118353390,118353443,118353866,442455983,442456926,442457437,442459612"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "squad_enabled_for_affiliates" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.squad_enabled_for_affiliates"
  description = "Boolean that determines whether squads is enabled for affliates"

  development = "false"
  staging     = "false"
  production  = "false"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "squad_enabled_for_partners" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.squad_enabled_for_partners"
  description = "Boolean that determines whether squads is enabled for partners"

  development = "true"
  staging     = "true"
  production  = "true"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "squad_enabled_whitelist" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.squad_enabled_whitelist"
  description = "Comma seperated userIDs that squads is enabled for"

  development = "60752857,184549472,30572359,254958722,237755203,237698523,40529315,153061467,264863151,123333107,138289128,417670224,522807365,442455983,442456926,442457437,442459612"
  staging     = "60752857,184549472,30572359,254958722,237755203,237698523,40529315,153061467,264863151,123333107,138289128,417670224,522807365,442455983,442456926,442457437,442459612"
  production  = "131953837,414821568,163603572,455759666,104354422,151748596,237755203,40529315,138289128,60752857,153817938,267332047,228722817,423132599,114673704,189632452,154292022,157444770,436025457,436026625,436026864,436027543,436027885,152088971,109247067,109530402,63375090,107591830,32374525,417670224,522807365"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "static_squads" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.static_squads"
  description = "Groups of comma seperated userIDs, each new line represents a squad. This is used to create test squads."

  development = ""
  staging     = ""
  production  = ""

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "livecheck_new_squad_grace_period" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.livecheck_new_squad_grace_period"
  description = "Amount of time a live squad is exempted from the members livecheck lambda."

  development = "10m"
  staging     = "10m"
  production  = "10m"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}

module "invite_notification_whitelist" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.invite_notification_whitelist"
  description = "Comma separated userIDs who can receive squad invite notifications, * for all accounts."

  development = "*"
  staging     = "*"
  production  = "*"

  providers = {
    aws.development = aws.development
    aws.staging     = aws.staging
    aws.production  = aws.production
  }
}
