terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/meepo/vpc_endpoints/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

# Create a data source to retrieve information on the VPC that Systems set up in the
# AWS account.
data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket  = var.account
    key     = "tfstate/feed/terraform/accounts/${var.account}"
    region  = var.region
    profile = var.account
  }
}

module "vpc_endpoints" {
  project           = var.project
  team_display_name = var.team_display_name
  owner             = var.owner

  source      = "../../modules/vpc_endpoints"
  environment = var.environment

  vpc_id          = data.terraform_remote_state.account.outputs.vpc_id
  private_subnets = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  security_groups = split(",", data.terraform_remote_state.account.outputs.twitch_subnets_sg)

  artifactory_dns_name = "pkgs.xarth.tv"
  follows_dns_name     = "us-west-2.prod.twitchvxfollowingserviceecs.s.twitch.a2z.com"
  friendship_dns_name  = "us-west-2.prod.twitchfriendship.s.twitch.a2z.com"
  hallpass_dns_name    = "prod.hallpass.cb.twitch.a2z.com"
  liveline_dns_name    = "main.production.liveline.twitch.a2z.com"
  receiver_dns_name    = "us-west-2.prod.twitchdartreceiver.s.twitch.a2z.com"
  ripley_dns_name      = "prod.ripley.twitch.a2z.com"
  roster_dns_name      = "prod.roster.cb.twitch.a2z.com"
  users_dns_name       = "prod.users-service.twitch.a2z.com"

  artifactory_service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-0ae1454184d60ff60"
  follows_service_name     = "com.amazonaws.vpce.us-west-2.vpce-svc-02ed47f998f8f23a2"
  friendship_service_name  = "com.amazonaws.vpce.us-west-2.vpce-svc-0f4be335e31768771"
  hallpass_service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-051cf257eb25dd6d5"
  liveline_service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-09e5395f949c1bf56"
  receiver_service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-0ce6ec756b1a5acba"
  ripley_service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e9e8a2896b1d5e89"
  roster_service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0308340fe7b6cc3e1"
  users_service_name       = "com.amazonaws.vpce.us-west-2.vpce-svc-044e493c84b7dc984"
}
