terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/meepo/lambda/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

# Create a data source to retrieve information on the VPC that Systems set up in the
# AWS account.
data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket  = var.account
    key     = "tfstate/feed/terraform/accounts/${var.account}"
    region  = var.region
    profile = var.account
  }
}

module "channel_livecheck" {
  source = "../../modules/lambda/channel_livecheck"

  project           = var.project
  team_display_name = var.team_display_name
  owner             = var.owner
  name              = var.name
  service_name      = var.service_name
  team_name         = var.team_name
  environment       = var.environment
  is_scheduled      = false

  // Rate in which this lambda is called, which also translates to how long a squad member can
  // be offline before being removed from squad.
  // Livecheck needs to be called twice on an offline squad member before a member can be removed,
  // this translates to a member being allowed to be offline for ~4 minutes
  rate = "rate(2 minutes)"

  meepo_host        = "http://staging.meepo.twitch.a2z.com"
  private_subnets   = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  twitch_subnets_sg = split(",", data.terraform_remote_state.account.outputs.twitch_subnets_sg)
}

module "ttl_deletion" {
  source = "../../modules/lambda/ttl_deletion"

  project           = var.project
  team_display_name = var.team_display_name
  owner             = var.owner
  name              = var.name
  service_name      = var.service_name
  team_name         = var.team_name
  environment       = var.environment
  is_scheduled      = false

  // Rate in which this lambda is called.
  rate = "rate(1 hour)"

  meepo_host        = "http://staging.meepo.twitch.a2z.com"
  private_subnets   = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  twitch_subnets_sg = split(",", data.terraform_remote_state.account.outputs.twitch_subnets_sg)
}

module "eventbus" {
  source = "../../modules/lambda/eventbus"

  project           = var.project
  team_display_name = var.team_display_name
  owner             = var.owner
  name              = var.name
  service_name      = var.service_name
  team_name         = var.team_name
  environment       = var.environment

  meepo_host        = "http://staging.meepo.twitch.a2z.com"
  private_subnets   = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  twitch_subnets_sg = split(",", data.terraform_remote_state.account.outputs.twitch_subnets_sg)
}
