terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/meepo/rds/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

# Create a data source to retrieve information on the VPC that Systems set up in the
# AWS account.
data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket  = var.account
    key     = "tfstate/feed/terraform/accounts/${var.account}"
    region  = var.region
    profile = var.account
  }
}

module "rds" {
  name              = var.name
  service_name      = var.service_name
  project           = var.project
  team_display_name = var.team_display_name
  environment       = var.environment
  owner             = var.owner

  source = "../../modules/rds"

  private_subnets   = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  twitch_subnets_sg = split(",", data.terraform_remote_state.account.outputs.twitch_subnets_sg)
}
