terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/meepo/vpc_endpoints/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

# Create a data source to retrieve information on the VPC that Systems set up in the
# AWS account.
data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket  = var.account
    key     = "tfstate/feed/terraform/accounts/${var.account}"
    region  = var.region
    profile = var.account
  }
}

module "vpc_endpoints" {
  project           = var.project
  team_display_name = var.team_display_name
  owner             = var.owner

  source      = "../../modules/vpc_endpoints"
  environment = var.environment

  vpc_id          = data.terraform_remote_state.account.outputs.vpc_id
  private_subnets = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  security_groups = split(",", data.terraform_remote_state.account.outputs.twitch_subnets_sg)

  artifactory_dns_name = "pkgs.xarth.tv"
  follows_dns_name     = "us-west-2.beta.twitchvxfollowingserviceecs.s.twitch.a2z.com"
  friendship_dns_name  = "us-west-2.beta.twitchfriendship.s.twitch.a2z.com"
  hallpass_dns_name    = "staging.hallpass.cb.twitch.a2z.com"
  liveline_dns_name    = "main.staging.liveline.twitch.a2z.com"
  receiver_dns_name    = "us-west-2.beta.twitchdartreceiver.s.twitch.a2z.com"
  ripley_dns_name      = "beta.ripley.twitch.a2z.com"
  roster_dns_name      = "staging.roster.cb.twitch.a2z.com"
  users_dns_name       = "dev.users-service.twitch.a2z.com"

  artifactory_service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-0ae1454184d60ff60"
  follows_service_name     = "com.amazonaws.vpce.us-west-2.vpce-svc-08682995a563a1413"
  friendship_service_name  = "com.amazonaws.vpce.us-west-2.vpce-svc-0cb3df78c5b8a0631"
  hallpass_service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-05c9a9682cec9fa80"
  liveline_service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-0e4e8f90d47bca00d"
  receiver_service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-00cc5f5ddd42126a0"
  ripley_service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0302ab0bc9133e1a4"
  roster_service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07312f19a8e971f87"
  users_service_name       = "com.amazonaws.vpce.us-west-2.vpce-svc-05dd975d62ccc04fe"
}
