package v1

// GetFeaturedChannelsRequestParams contains required parameters
// for making a GET /v1/teams/:team_id/featured_channels request.
type GetFeaturedChannelsRequestParams struct {
	TeamID string // route
}

// GetFeaturedChannelsResponse is the response body of the
// GET /v1/teams/:team_id/featured_channels API.
type GetFeaturedChannelsResponse struct {
	Data []GetFeaturedChannelsData `json:"data"`
}

// GetFeaturedChannelsData is a single unit of GetFeaturedChannelsResponse.Data.
type GetFeaturedChannelsData struct {
	ChannelID string `json:"channel_id"`
	TeamID    string `json:"team_id"`
}
