package v1

// GetTeamLiveMembershipsRequestParams contains optional parameters
// for making a GET /v1/teams/:team_id/live_memberships request.
type GetTeamLiveMembershipsRequestParams struct {
	TeamID string // route
}

// GetTeamLiveMembershipsResponse is the response body of the
// GET /v1/teams/:team_id/live_memberships API.
type GetTeamLiveMembershipsResponse struct {
	Meta GetTeamLiveMembershipsMeta   `json:"meta"`
	Data []GetTeamLiveMembershipsData `json:"data"`
}

// GetTeamLiveMembershipsMeta contains the metadata of GetTeamLiveMembershipsResponse.
type GetTeamLiveMembershipsMeta struct {
	Team Team `json:"team"`
}

// GetTeamLiveMembershipsData is a single unit of GetTeamLiveMembershipsResponse.Data.
type GetTeamLiveMembershipsData struct {
	ChannelID       string `json:"channel_id"`
	TeamID          string `json:"team_id"`
	RevenueRevealed bool   `json:"revenue_revealed"`
	StatsRevealed   bool   `json:"stats_revealed"`
}
