package v1

// Sort specifies the sorting direction.
type Sort string

// Sort can only have one of two directions: ascending or descending.
const (
	SortAsc  Sort = "asc"
	SortDesc Sort = "desc"
)

// GetTeamsRequestParams contains optional parameters
// for making a GET /v1/teams request.
type GetTeamsRequestParams struct {
	Limit  uint
	Name   string
	Offset uint
	Sort   Sort
	UserID string
}

// GetTeamsResponse is the response body of the GET /v1/teams API.
type GetTeamsResponse struct {
	Meta GetTeamsMeta `json:"meta"`
	Data []Team       `json:"data"`
}

// GetTeamsMeta contains metadata for GetTeamsResponse.
type GetTeamsMeta struct {
	Limit  uint `json:"limit"`
	Offset uint `json:"offset"`
	Sort   Sort `json:"sort"`
	Total  uint `json:"total"`
}
