package v1

// PatchTeamRequestParams contains required and optional parameters
// for making a PATCH /v1/teams/:team_id request.
type PatchTeamRequestParams struct {
	TeamID string

	DisplayName         *string
	UserID              *string
	DescriptionMarkdown *string
	LogoID              *NullString
	BannerID            *NullString
	BackgroundImageID   *NullString
}

// PatchTeamRequestBody is the required request body
// of the PATCH /v1/teams/:team_id API.
type PatchTeamRequestBody struct {
	DisplayName         *string     `json:"display_name,omitempty"`
	DescriptionMarkdown *string     `json:"description_markdown,omitempty"`
	UserID              *string     `json:"user_id,omitempty"`
	LogoID              *NullString `json:"logo_id,omitempty"`
	BannerID            *NullString `json:"banner_id,omitempty"`
	BackgroundImageID   *NullString `json:"background_image_id,omitempty"`
}

// PatchTeamResponse is the expected response body
// of the PATCH /v1/teams/:team_id API.
type PatchTeamResponse struct {
	Data Team `json:"data"`
}
