package v1

// PostFeaturedChannelsRequestParams is the required request
// parameters of the POST /v1/teams/:team_id/featured_channels API.
type PostFeaturedChannelsRequestParams struct {
	TeamID    string
	ChannelID string
}

// PostFeaturedChannelsRequestBody is the required request body
// of the POST /v1/teams/:team_id/featured_channels API.
type PostFeaturedChannelsRequestBody struct {
	ChannelID string `json:"channel_id"`
}

// PostFeaturedChannelsResponse is the response body of the
// POST /v1/teams/:team_id/featured_channels API.
type PostFeaturedChannelsResponse struct {
	Data PostFeaturedChannelsData `json:"data"`
}

// PostFeaturedChannelsData is a newly created featured channel.
type PostFeaturedChannelsData struct {
	TeamID    string `json:"team_id"`
	ChannelID string `json:"channel_id"`
}
