package v1

// PostImageUploadsRequestParams is the required request
// parameters of the POST /v1/teams/:team_id/image_uploads API.
type PostImageUploadsRequestParams struct {
	TeamID   string
	Category string
	FileType string
	Size     uint64
}

// PostImageUploadsRequestBody is the required request body
// of the POST /v1/teams/:team_id/image_uploads API.
type PostImageUploadsRequestBody struct {
	Category string `json:"category"`
	FileType string `json:"file_type"`
	Size     uint64 `json:"size"`
}

// PostImageUploadsResponse is the response body of the
// POST /v1/teams/:team_id/image_uploads API.
type PostImageUploadsResponse struct {
	Data PostImageUploadsData `json:"data"`
}

// PostImageUploadsData is a newly created invitation.
type PostImageUploadsData struct {
	ImageID string `json:"image_id"`
	URL     string `json:"url"`
}
