package v1

// PostTeamMembershipsRequestParams is the required request
// parameters of the POST /v1/teams/:team_id/memberships API.
type PostTeamMembershipsRequestParams struct {
	TeamID    string
	ChannelID string
}

// PostTeamMembershipsRequestBody is the required request body
// of the POST /v1/teams/:team_id/memberships API.
type PostTeamMembershipsRequestBody struct {
	ChannelID       string `json:"channel_id"`
	RevenueRevealed *bool  `json:"revenue_revealed"`
	StatsRevealed   *bool  `json:"stats_revealed"`
}

// PostTeamMembershipsResponse is the response body of the
// POST /v1/teams/:team_id/memberships API.
type PostTeamMembershipsResponse struct {
	Data PostTeamMembershipsData `json:"data"`
}

// PostTeamMembershipsData is a newly created membership.
type PostTeamMembershipsData struct {
	ChannelID       string `json:"channel_id"`
	TeamID          string `json:"team_id"`
	Primary         bool   `json:"primary"`
	RevenueRevealed bool   `json:"revenue_revealed"`
	StatsRevealed   bool   `json:"stats_revealed"`
}
