package v1

// PostTeamsRequestParams is the required request
// parameters of the POST /v1/users/:user_id/teams API.
type PostTeamsRequestParams struct {
	Name                string
	DisplayName         string
	UserID              string
	DescriptionMarkdown *string
}

// PostTeamsRequestBody is the required request body
// of the POST /v1/users/:user_id/teams API.
type PostTeamsRequestBody struct {
	Name                string  `json:"name"`
	DisplayName         string  `json:"display_name"`
	DescriptionMarkdown *string `json:"description_markdown"`
}

// PostTeamsResponse is the response body of the
// POST /v1/users/:user_id/teams API.
type PostTeamsResponse struct {
	Data Team `json:"data"`
}
