package v1

// PutChannelMembershipRequestParams contains the parameters for making a
// PUT /v1/channels/:channel_id/teams/:team_id/membership request.
type PutChannelMembershipRequestParams struct {
	ChannelID string
	TeamID    string

	Primary         *bool
	RevenueRevealed bool
	StatsRevealed   bool
}

// PutChannelMembershipRequestBody is the required request body
// of the PUT /v1/channels/:channel_id/teams/:team_id/membership API.
type PutChannelMembershipRequestBody struct {
	Primary         *bool `json:"primary"`
	RevenueRevealed *bool `json:"revenue_revealed"`
	StatsRevealed   *bool `json:"stats_revealed"`
}
