package v1

// SearchTeamsRequestParams contains optional parameters
// for making a GET /v1/search/teams request.
type SearchTeamsRequestParams struct {
	Limit  uint
	Name   string
	Offset uint
}

// SearchTeamsResponse is the response body of the GET /v1/search/teams API.
type SearchTeamsResponse struct {
	Meta SearchTeamsMeta `json:"meta"`
	Data []Team          `json:"data"`
}

// SearchTeamsMeta contains metadata for SearchTeamsResponse.
type SearchTeamsMeta struct {
	Limit  uint `json:"limit"`
	Offset uint `json:"offset"`
	Total  uint `json:"total"`
}
